package com.intellij.psi.css.descriptor.value;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;

/**
 * User: zolotov
 * Date: 7/5/13
 */
public class CssNullValue implements CssValueDescriptor {

  @Nullable private final CssValueDescriptor myParent;

  public CssNullValue() {
    this(null);
  }


  public CssNullValue(@Nullable CssValueDescriptor parent) {
    myParent = parent;
  }

  @NotNull
  @Override
  public CssVersion getCssVersion() {
    return CssVersion.UNKNOWN;
  }

  @NotNull
  @Override
  public BrowserVersion[] getBrowsers() {
    return BrowserVersion.EMPTY_ARRAY;
  }

  @Override
  public boolean isAllowedInContextType(@NotNull CssContextType contextType) {
    return false;
  }

  @NotNull
  @Override
  public String getId() {
    return "";
  }

  @NotNull
  @Override
  public String getPresentableName() {
    return "null";
  }

  @NotNull
  @Override
  public String getDescription() {
    return "";
  }

  @Nullable
  @Override
  public String getDocumentationString(@Nullable PsiElement context) {
    return null;
  }

  @NotNull
  @Override
  public String getElementTypeName() {
    return "null";
  }

  @Nullable
  @Override
  public String getSpecificationUrl() {
    return null;
  }

  @NotNull
  @Override
  public CssContextType[] getAllowedContextTypes() {
    return CssContextType.EMPTY_ARRAY;
  }

  @Nullable
  @Override
  public Icon getIcon() {
    return null;
  }

  @Override
  public <T extends CssValueDescriptorVisitor> void accept(T visitor) {
    visitor.visitValue(this);
  }

  @Nullable
  @Override
  public CssValueDescriptor getParent() {
    return myParent;
  }

  @Override
  public int getMinOccur() {
    return 0;
  }

  @Override
  public int getMaxOccur() {
    return 0;
  }

  @Nullable
  @Override
  public CssVersion getObsoleteVersion() {
    return null;
  }

  @Nullable
  @Override
  public String getObsoleteTooltip() {
    return null;
  }

  @Nullable
  @Override
  public CssValueDescriptor getExclusion() {
    return null;
  }

  @Override
  public boolean isShowInCompletion() {
    return false;
  }

  @Override
  public boolean isCommaSeparated() {
    return false;
  }
}
