package com.intellij.psi.css.impl.util.table;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author spleaner
*/
interface CssTableValueVisitor<V extends CssTableValue> {
  void visit(@NotNull final V value);

  abstract class Recursive<V extends CssTableValue> implements CssTableValueVisitor<V> {
    abstract void visitValue(@NotNull final V value);

    @Override
    public void visit(@NotNull final V value) {
      visitValue(value);
      if (value.isGroup()) {
        for (final V each : (List<V>)value.getChildren()) {
          each.accept(this);
        }
      }
    }
  }
}
