/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.psi.css.resolve;

import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

public interface CssResolver {
  String NO_CLASS = "";

  @NonNls String ALTERNATE_STYLE_SHEET_NAME = "alternate";

  CssDeclaration[] resolve(XmlTag tag);
  CssDeclaration[] resolve(XmlTag tag, PsiFile[] xhtmlFiles, @Nullable String styleSheet);

  CssRuleset[] resolveAll(XmlFile file);

  String[] resolveStyleSheetNames(XmlFile file);

  CssRuleset[] resolveAllRulesetsForTag(XmlTag tag);

  @NotNull StylesheetFile[] resolveStyleSheets(@NotNull XmlFile file, @Nullable String styleSheet);

  Map<String,Map<String,CssDeclaration>> resolveActiveDeclarations (XmlTag tag, XmlFile[] xhtmlFiles);

  boolean processOneFile(XmlFile xmlFile, CssElementProcessor processor, boolean withImports);

  void setDefaultStylesheet(CssStylesheet stylesheet);

  void setResolvingProcessListener(ResolvingProcessListener listener);

  // Strict resolve mode always relies on LINK/STYLE attributes
  void setStrictResolveMode(boolean strictMode);
  void setProcessAllCssFilesMode(boolean mode);

  void setUseAgentStylesheet(boolean b);

  void setResolvedAttrName(String s);
  String getResolvedAttrName();

  void setCareAboutClasses(boolean b);
  boolean isCareAboutClasses();

  void setSelectorMatcher(CssSelectorMatcher selectorMatcher);
}
