/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.constants;

import org.jetbrains.annotations.NonNls;

/**
 * @author Sergey Vasiliev
 */
public interface SpringAnnotationsConstants {
  // java config
  @Deprecated
  @NonNls String JAVA_CONFIG_CONFIGURATION = "org.springframework.config.java.annotation.Configuration";
  @Deprecated
  @NonNls String JAVA_CONFIG_BEAN = "org.springframework.config.java.annotation.Bean";
  @Deprecated
  @NonNls String JAVA_CONFIG_EXTERNAL_BEAN = "org.springframework.config.java.annotation.ExternalBean";
  @NonNls String JAVA_CONFIG_SCOPED_PROXY = "org.springframework.config.java.annotation.aop.ScopedProxy";

  // java config in spring 3.0
  @NonNls String JAVA_SPRING_CONFIGURATION = "org.springframework.context.annotation.Configuration";
  @NonNls String JAVA_SPRING_BEAN = "org.springframework.context.annotation.Bean";

  @NonNls String CONTEXT_IMPORT = "org.springframework.context.annotation.Import";
  @NonNls String CONTEXT_IMPORT_RESOURCE = "org.springframework.context.annotation.ImportResource";

  @NonNls String SCOPE = "org.springframework.context.annotation.Scope";

  @NonNls String PRIMARY = "org.springframework.context.annotation.Primary";
  @NonNls String ORDER = "org.springframework.core.annotation.Order";

  // stereotypes
  @NonNls String COMPONENT = "org.springframework.stereotype.Component";
  @NonNls String CONTROLLER = "org.springframework.stereotype.Controller";
  @NonNls String REPOSITORY = "org.springframework.stereotype.Repository";
  @NonNls String SERVICE = "org.springframework.stereotype.Service";

  // autowired annotations
  @NonNls String AUTOWIRED = "org.springframework.beans.factory.annotation.Autowired";
  @NonNls String INJECT = "javax.inject.Inject"; // spring 3.0 support for JSR-330
  @NonNls String NAMED = "javax.inject.Named"; // spring 3.0 support for JSR-330
  @NonNls String JAVAX_INJECT_QUALIFIER = "javax.inject.Qualifier"; // spring 3.0 support for JSR-330
  @NonNls String VALUE = "org.springframework.beans.factory.annotation.Value";

  // spring 3.1
  @NonNls String PROFILE = "org.springframework.context.annotation.Profile";
  @NonNls String COMPONENT_SCAN = "org.springframework.context.annotation.ComponentScan";
  @NonNls String COMPONENT_SCAN_FILTER = "org.springframework.context.annotation.ComponentScan.Filter";
  @NonNls String COMPONENT_SCAN_FILTER_TYPE = "org.springframework.context.annotation.FilterType";
  @NonNls String ACTIVE_PROFILES = "org.springframework.test.context.ActiveProfiles";
  @NonNls String PROPERTY_SOURCE = "org.springframework.context.annotation.PropertySource";
  @NonNls String PROPERTY_SOURCES = "org.springframework.context.annotation.PropertySources";

  // Spring 4.x
  @NonNls String CONTEXT_DESCRIPTION = "org.springframework.context.annotation.Description";

  // Spring 4.2
  @NonNls String EVENT_LISTENER = "org.springframework.context.event.EventListener";
  @NonNls String ROOT_OBJECT_CLASS = "org.springframework.context.event.EventExpressionRootObject";
  @NonNls String ALIAS_FOR = "org.springframework.core.annotation.AliasFor";

  // Spring 4.3
  @NonNls String COMPONENT_SCANS = "org.springframework.context.annotation.ComponentScans";

  // spring 2.X
  @NonNls String CONFIGURABLE = "org.springframework.beans.factory.annotation.Configurable";
  @NonNls String QUALIFIER = "org.springframework.beans.factory.annotation.Qualifier";
  @NonNls String REQUIRED = "org.springframework.beans.factory.annotation.Required";


  // javax annotations
  @NonNls String JAVAX_MANAGED_BEAN = "javax.annotation.ManagedBean";
  @NonNls String JAVAX_RESOURCE = "javax.annotation.Resource";
  @NonNls String JAVAX_PRE_DESTROY = "javax.annotation.PreDestroy";
  @NonNls String JAVAX_POST_DESTROY = "javax.annotation.PostConstruct";

  @NonNls String CUSTOM_AUTOWIRE_CONFIGURER_CLASS = "org.springframework.beans.factory.annotation.CustomAutowireConfigurer";

  @NonNls String LOOKUP_ANNOTATION = "org.springframework.beans.factory.annotation.Lookup";

  // tests
  @NonNls String CONTEXT_HIERARCHY = "org.springframework.test.context.ContextHierarchy";
  @NonNls String CONTEXT_CONFIGURATION = "org.springframework.test.context.ContextConfiguration";
  @NonNls String TRANSACTION_CONFIGURATION = "org.springframework.test.context.transaction.TransactionConfiguration";
  @NonNls String TEST_PROPERTY_SOURCE = "org.springframework.test.context.TestPropertySource";
  @NonNls String TEST_SQL = "org.springframework.test.context.jdbc.Sql";
  @NonNls String TEST_SQL_CONFIG = "org.springframework.test.context.jdbc.SqlConfig";
  @NonNls String DIRTIES_CONTEXT = "org.springframework.test.annotation.DirtiesContext";

  // transaction
  @NonNls String TRANSACTIONAL = "org.springframework.transaction.annotation.Transactional";
  @NonNls String PLATFORM_TRANSACTION_MANAGER = "org.springframework.transaction.PlatformTransactionManager";

  // jmx
  @NonNls String JMX_MANAGED_OPERATION = "org.springframework.jmx.export.annotation.ManagedOperation";
  @NonNls String JMX_MANAGED_ATTRIBUTE = "org.springframework.jmx.export.annotation.ManagedAttribute";

  // scheduling
  @NonNls String SCHEDULED = "org.springframework.scheduling.annotation.Scheduled";
  @NonNls String ASYNC = "org.springframework.scheduling.annotation.Async";

  // test transactions
  @NonNls String TEST_BEFORE_TRANSACTION = "org.springframework.test.context.transaction.BeforeTransaction";
  @NonNls String TEST_AFTER_TRANSACTION = "org.springframework.test.context.transaction.AfterTransaction";

  @NonNls String JAVAX_SERVLET_WEB_SERVLET = "javax.servlet.annotation.WebServlet";
}
