/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.editor;

import com.intellij.application.options.editor.EditorAppearanceConfigurable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.spring.SpringApiBundle;
import com.intellij.ui.ClickListener;
import com.intellij.ui.EditorNotificationPanel;
import org.jetbrains.annotations.NotNull;

import java.awt.*;
import java.awt.event.MouseEvent;

/**
 * @since 14.1
 */
public abstract class SpringEditorNotificationPanel extends EditorNotificationPanel {
  public SpringEditorNotificationPanel() {
  }

  public SpringEditorNotificationPanel(Color backgroundColor) {
    super(backgroundColor);
  }

  protected void installOpenEditorSettingsButton(final Project project) {
    myGearLabel.setIcon(AllIcons.General.Settings);
    myGearLabel.setToolTipText(SpringApiBundle.message("editor.panel.edit.settings"));
    myGearLabel.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));

    new ClickListener() {
      @Override
      public boolean onClick(@NotNull MouseEvent e, int clickCount) {
        final EditorAppearanceConfigurable configurable = new EditorAppearanceConfigurable();
        ShowSettingsUtil.getInstance().editConfigurable(project, configurable);
        return true;
      }
    }.installOn(myGearLabel);
  }
}
