/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.facet;

import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;
import java.util.Set;

/**
 * @since 15
 */
public abstract class SpringAutodetectedFileSet extends SpringFileSet {

  private final Icon myIcon;

  protected SpringAutodetectedFileSet(String id, String name, SpringFacet parent,
                                      final Icon icon) {
    super(id, name, parent);
    myIcon = icon;
  }

  @Override
  public final Icon getIcon() {
    return myIcon;
  }

  @Override
  public final boolean isAutodetected() {
    return true;
  }

  @Override
  protected final VirtualFilePointer createVirtualFilePointer(@NotNull String url) {
    return new LightFilePointer(url);
  }

  @Override
  public final void setActiveProfiles(@NotNull Set<String> activeProfiles) {
    super.setActiveProfiles(activeProfiles);
    getFacet().getConfiguration().setActiveProfilesForAutodetected(getId(), activeProfiles);
  }
}
