/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.converters;

import com.intellij.psi.PsiClass;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.PsiClassConverter;

/**
 * @author Dmitry Avdeev
 */
public class SpringDomQualifierTypeConverter extends PsiClassConverter {

  public PsiClass fromString(final String s, final ConvertContext context) {
    if (s == null) {
      return DomJavaUtil.findClass(SpringAnnotationsConstants.QUALIFIER,
                                   context.getFile(), context.getModule(), null);
    }
    return super.fromString(s, context);
  }
}
