/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.converters;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.*;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PatternPackageReferenceSet;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJamConverter extends JamConverter<PsiPackage> {

  @Override
  public PsiPackage fromString(@Nullable String s, JamStringAttributeElement<PsiPackage> context) {
    if (StringUtil.isEmptyOrSpaces(s)) return null;
    return JavaPsiFacade.getInstance(context.getPsiManager().getProject()).findPackage(s.trim());
  }

  @NotNull
  @Override
  public PsiReference[] createReferences(JamStringAttributeElement<PsiPackage> context) {
    final PsiLiteral psiLiteral = context.getPsiLiteral();
    if (psiLiteral == null) {
      return PsiReference.EMPTY_ARRAY;
    }

    final String value = context.getStringValue();
    if (value == null) {
      return PsiReference.EMPTY_ARRAY;
    }

    PatternPackageReferenceSet set =
      new PatternPackageReferenceSet(value, psiLiteral, ElementManipulators.getOffsetInElement(psiLiteral),
                                     SpringReferenceUtils.getResolveScope(psiLiteral));
    return set.getPsiReferences();
  }
}
