/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifier;
import com.intellij.semantic.SemKey;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;

import static com.intellij.patterns.PsiJavaPatterns.psiClass;

@Presentation(typeName = "@Configuration")
public class SpringConfiguration extends SpringMetaStereotypeComponent {

  public static final SemKey<JamMemberMeta<PsiClass, SpringConfiguration>> META_KEY =
    JamService.ALIASING_MEMBER_META_KEY.subKey("SpringConfigurationMeta");

  /**
   * @see com.intellij.spring.model.utils.SpringCommonUtils#isConfiguration(PsiClass)
   * @see com.intellij.spring.model.utils.SpringCommonUtils#isConfigurationOrMeta(PsiClass)
   */
  public static final SemKey<SpringConfiguration> JAM_KEY =
    JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY.subKey("SpringConfiguration");

  public static final JamClassMeta<SpringConfiguration> META =
    new JamClassMeta<>(null, SpringConfiguration.class, JAM_KEY);

  /**
   * @deprecated To remove in 2017.2
   */
  @Deprecated
  public static final PsiClassPattern PSI_CLASS_PATTERN = psiClass().nonAnnotationType()
    .withoutModifiers(PsiModifier.PRIVATE, PsiModifier.ABSTRACT);

  private static final Function<Module, Collection<String>> ANNOTATIONS =
    module -> getAnnotations(module, SpringAnnotationsConstants.JAVA_SPRING_CONFIGURATION);

  public SpringConfiguration(@NotNull PsiClass psiClass) {
    super(SpringAnnotationsConstants.JAVA_SPRING_CONFIGURATION, psiClass);
  }

  public SpringConfiguration(@NotNull String anno, @NotNull PsiClass psiClass) {
    super(anno, psiClass);
  }

  @NotNull
  public Collection<SpringPropertySource> getPropertySources() {
    return SpringJamUtils.getInstance().getPropertySources(getPsiElement());
  }

  /**
   * @deprecated To remove in 2017.2
   */
  @Deprecated
  @NotNull
  public static Function<Pair<String, PsiClass>, SpringConfiguration> getProducer() {
    return pair -> new SpringConfiguration(pair.first, pair.second);
  }

  @NotNull
  public static Function<Module, Collection<String>> getAnnotations() {
    return ANNOTATIONS;
  }
}
