/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.spring.model.xml.beans;

import com.intellij.spring.constants.SpringConstants;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.PropertyLocalSpringBeanResolveConverter;
import com.intellij.spring.model.converters.SpringBeanResolveConverter;
import com.intellij.util.xml.*;
import org.jetbrains.annotations.NotNull;

/**
 * @author Dmitry Avdeev
 */
@Namespace(SpringConstants.BEANS_NAMESPACE_KEY)
public interface RefBase extends DomElement {
  /**
	 * Returns the value of the bean child.
   * <pre>
   * <h3>Attribute null:bean documentation</h3>
   * 	The name of the referenced bean.
   *
   * </pre>
   * @return the value of the bean child.
   */
  @NotNull
  @Convert(value = SpringBeanResolveConverter.PropertyBean.class)
  @Stubbed
  GenericAttributeValue<SpringBeanPointer> getBean();

  /**
	 * Returns the value of the local child.
   * <pre>
   * <h3>Attribute null:local documentation</h3>
   * 	The name of the referenced bean. The value must be a bean ID,
   * 	and thus can be checked by the XML parser, thus should be preferred
   * 	for references within the same bean factory XML file.
   *
   * </pre>
   * @return the value of the local child.
   */
  @NotNull
  @Convert(value = PropertyLocalSpringBeanResolveConverter.class)
  @Stubbed
  GenericAttributeValue<SpringBeanPointer> getLocal();
}
