package com.intellij.sql.psi;

import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author Gregory.Shrago
 */
public interface SqlAlterTableInstruction extends SqlElement {

  SqlAlterTableInstruction[] EMPTY_ARRAY = new SqlAlterTableInstruction[0];
  ArrayFactory<SqlAlterTableInstruction> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new SqlAlterTableInstruction[count];

  @Nullable
  IElementType getInstructionType();
}