/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.ui;

import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author peter
 */
public abstract class ComplexElementWrapper<T extends JavaeeDomModelElement> implements DialogElementWrapper<T>{
  private final DialogElementWrapper<T> myDelegate;

  protected ComplexElementWrapper(@NotNull Project project, @Nullable T existingElement, Class<T> aClass, JavaeeFacet facet) {
    if (existingElement == null) {
      myDelegate = new NewElementWrapper<T>(project, aClass, facet) {

        @Override
        protected void initMockElement(T t) {
          ComplexElementWrapper.this.initMockElement(t);
        }

        protected T createRealElement() {
          return ComplexElementWrapper.this.createRealElement();
        }
      };
    } else {
      myDelegate = new ExistingElementWrapper<>(existingElement, facet);
    }
  }

  protected abstract T createRealElement();

  protected void initMockElement(T t) {
  }

  public final T getElement() {
    return myDelegate.getElement();
  }

  public final T save() {
    return myDelegate.save();
  }

  public final String getDialogTitle() {
    return myDelegate.getDialogTitle();
  }
}
