/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.intellij.util.Consumer;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTextUtils {
    private AndroidTextUtils() {
    }

    @NotNull
    public static String generateCommaSeparatedList(@NotNull Collection<String> items, @NotNull String lastSeparator) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/AndroidTextUtils", "generateCommaSeparatedList"));
        }
        if (lastSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastSeparator", "com/android/tools/idea/AndroidTextUtils", "generateCommaSeparatedList"));
        }
        int n = items.size();
        if (n == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/AndroidTextUtils", "generateCommaSeparatedList"));
            }
            return "";
        }
        int i = 0;
        StringBuilder result = new StringBuilder();
        for (String word : items) {
            result.append(word);
            if (i < n - 2) {
                result.append(", ");
            } else if (i == n - 2) {
                result.append(" ").append(lastSeparator).append(" ");
            }
            ++i;
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/AndroidTextUtils", "generateCommaSeparatedList"));
        }
        return string;
    }

    public static void forEachOccurrence(@NotNull String haystack, char needle, @NotNull Consumer<Integer> callback) {
        if (haystack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "haystack", "com/android/tools/idea/AndroidTextUtils", "forEachOccurrence"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/idea/AndroidTextUtils", "forEachOccurrence"));
        }
        AndroidTextUtils.forEachOccurrence(haystack, needle, 0, callback);
    }

    public static void forEachOccurrence(@NotNull String haystack, char needle, int startIndex, @NotNull Consumer<Integer> callback) {
        if (haystack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "haystack", "com/android/tools/idea/AndroidTextUtils", "forEachOccurrence"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/idea/AndroidTextUtils", "forEachOccurrence"));
        }
        int curr = haystack.indexOf(needle, startIndex);
        while (curr != -1) {
            callback.consume((Object)curr);
            curr = haystack.indexOf(needle, curr + 1);
        }
    }

    @Nullable
    @Contract(pure=true)
    public static String trimEndOrNullize(@NotNull String haystack, @NotNull String needle) {
        if (haystack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "haystack", "com/android/tools/idea/AndroidTextUtils", "trimEndOrNullize"));
        }
        if (needle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "needle", "com/android/tools/idea/AndroidTextUtils", "trimEndOrNullize"));
        }
        if (haystack.endsWith(needle)) {
            return haystack.substring(0, haystack.length() - needle.length());
        }
        return null;
    }
}

