/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.base.Strings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidActionGroupRemover
extends ActionGroup {
    @NotNull
    private final ActionGroup myDelegate;

    public AndroidActionGroupRemover(@NotNull ActionGroup delegate, @NotNull String backupText) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/android/tools/idea/actions/AndroidActionGroupRemover", "<init>"));
        }
        if (backupText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backupText", "com/android/tools/idea/actions/AndroidActionGroupRemover", "<init>"));
        }
        super(delegate.getTemplatePresentation().getTextWithMnemonic(), delegate.getTemplatePresentation().getDescription(), delegate.getTemplatePresentation().getIcon());
        this.myDelegate = delegate;
        Presentation presentation = this.getTemplatePresentation();
        if (Strings.isNullOrEmpty((String)presentation.getText())) {
            presentation.setText(backupText);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        this.myDelegate.actionPerformed(e);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project != null && AndroidProjectInfo.getInstance(project).requiresAndroidModel()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabledAndVisible(true);
        AndroidActionGroupRemover.updateTextAndIcon(this.getTemplatePresentation(), this.myDelegate.getTemplatePresentation());
        this.myDelegate.update(e);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = this.myDelegate.getChildren(e);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/AndroidActionGroupRemover", "getChildren"));
        }
        return anActionArray;
    }

    private static void updateTextAndIcon(@NotNull Presentation source, @NotNull Presentation destination) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/actions/AndroidActionGroupRemover", "updateTextAndIcon"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/actions/AndroidActionGroupRemover", "updateTextAndIcon"));
        }
        destination.setText(source.getTextWithMnemonic());
        destination.setIcon(source.getIcon());
    }

    public boolean isPopup() {
        return this.myDelegate.isPopup();
    }
}

