/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.res.LocalResourceRepository;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public abstract class ResourceCacheValueProvider<T>
implements CachedValueProvider<T>,
ModificationTracker {
    ModificationTracker[] myAdditionalTrackers;
    private ModificationTracker myTracker = new ModificationTracker(){
        private long myLastVersion = -1L;
        private long myVersion = 0L;

        public long getModificationCount() {
            long version;
            LocalResourceRepository moduleResources = ResourceCacheValueProvider.this.myFacet.getModuleResources(false);
            long l = version = moduleResources == null ? Integer.MIN_VALUE : moduleResources.getModificationCount();
            if (version != this.myLastVersion) {
                this.myLastVersion = version;
                ++this.myVersion;
            }
            return this.myVersion;
        }
    };
    private final AndroidFacet myFacet;

    public ResourceCacheValueProvider(AndroidFacet facet, ModificationTracker ... additionalTrackers) {
        this.myFacet = facet;
        this.myAdditionalTrackers = additionalTrackers;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    public long getModificationCount() {
        return this.myTracker.getModificationCount();
    }

    @NotNull
    public final CachedValueProvider.Result<T> compute() {
        if (this.myFacet.getModuleResources(false) == null) {
            CachedValueProvider.Result result = CachedValueProvider.Result.create(this.defaultValue(), (Object[])new Object[]{this.myTracker, this.myAdditionalTrackers});
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/ResourceCacheValueProvider", "compute"));
            }
            return result;
        }
        CachedValueProvider.Result result = CachedValueProvider.Result.create(this.doCompute(), (Object[])new Object[]{this.myTracker, this.myAdditionalTrackers});
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/ResourceCacheValueProvider", "compute"));
        }
        return result;
    }

    abstract T doCompute();

    abstract T defaultValue();
}

