/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeResolver {
    private final Map<String, ConfiguredThemeEditorStyle> myThemeByName;
    private final ImmutableList<ConfiguredThemeEditorStyle> myFrameworkThemes;
    private final ImmutableList<ConfiguredThemeEditorStyle> myLocalThemes;
    private final ImmutableList<ConfiguredThemeEditorStyle> myExternalLibraryThemes;
    private final Configuration myConfiguration;
    private final ResourceResolver myResolver;

    public ThemeResolver(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ThemeResolver", "<init>"));
        }
        this.myThemeByName = Maps.newHashMap();
        this.myConfiguration = configuration;
        this.myResolver = configuration.getResourceResolver();
        if (this.myResolver == null) {
            throw new IllegalArgumentException("Acquired ResourceResolver is null, not an Android module?");
        }
        this.myFrameworkThemes = this.fillThemeResolverFromStyles(this.resolveFrameworkThemes());
        ImmutableList.Builder localThemes = ImmutableList.builder();
        for (Pair<StyleResourceValue, Module> pair : this.resolveLocallyDefinedModuleThemes()) {
            ConfiguredThemeEditorStyle theme = this.constructThemeFromResourceValue((StyleResourceValue)pair.getFirst(), (Module)pair.getSecond());
            if (theme == null) continue;
            localThemes.add((Object)theme);
        }
        this.myLocalThemes = localThemes.build();
        this.myExternalLibraryThemes = this.fillThemeResolverFromStyles(this.resolveNonFrameworkThemes());
    }

    @Nullable
    private ConfiguredThemeEditorStyle constructThemeFromResourceValue(@NotNull StyleResourceValue value, @Nullable Module sourceModule) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/ThemeResolver", "constructThemeFromResourceValue"));
        }
        String name = ResolutionUtils.getQualifiedStyleName(value);
        if (this.myThemeByName.containsKey(name)) {
            return null;
        }
        ConfiguredThemeEditorStyle theme = ResolutionUtils.getStyle(this.myConfiguration, name, sourceModule);
        if (theme != null) {
            this.myThemeByName.put(name, theme);
        }
        return theme;
    }

    private ImmutableList<ConfiguredThemeEditorStyle> fillThemeResolverFromStyles(@NotNull List<StyleResourceValue> source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/editors/theme/ThemeResolver", "fillThemeResolverFromStyles"));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (StyleResourceValue value : source) {
            ConfiguredThemeEditorStyle theme = this.constructThemeFromResourceValue(value, null);
            if (theme == null) continue;
            builder.add((Object)theme);
        }
        return builder.build();
    }

    @NotNull
    private List<StyleResourceValue> resolveFrameworkThemes() {
        ResourceRepository repository = this.myConfiguration.getFrameworkResources();
        if (repository == null) {
            List<StyleResourceValue> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "resolveFrameworkThemes"));
            }
            return list;
        }
        List<StyleResourceValue> list = this.getThemes((ResourceValueMap)repository.getConfiguredResources(this.myConfiguration.getFullConfig()).get(ResourceType.STYLE), true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "resolveFrameworkThemes"));
        }
        return list;
    }

    @NotNull
    private List<StyleResourceValue> resolveNonFrameworkThemes() {
        AppResourceRepository repository = AppResourceRepository.getAppResources(this.myConfiguration.getModule(), true);
        if (repository == null) {
            List<StyleResourceValue> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "resolveNonFrameworkThemes"));
            }
            return list;
        }
        List<StyleResourceValue> list = this.getThemes(repository.getConfiguredResources(ResourceType.STYLE, this.myConfiguration.getFullConfig()), false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "resolveNonFrameworkThemes"));
        }
        return list;
    }

    @NotNull
    private List<Pair<StyleResourceValue, Module>> resolveLocallyDefinedModuleThemes() {
        Module module = this.myConfiguration.getModule();
        ArrayList result = Lists.newArrayList();
        this.fillModuleResources(module, ModuleResourceRepository.getModuleResources(module, true), result);
        List<AndroidFacet> allAndroidDependencies = AndroidUtils.getAllAndroidDependencies(module, false);
        for (AndroidFacet facet : allAndroidDependencies) {
            this.fillModuleResources(facet.getModule(), facet.getModuleResources(true), result);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "resolveLocallyDefinedModuleThemes"));
        }
        return arrayList;
    }

    private void fillModuleResources(@NotNull Module module, @Nullable LocalResourceRepository repository, @NotNull List<Pair<StyleResourceValue, Module>> sink) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeResolver", "fillModuleResources"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/android/tools/idea/editors/theme/ThemeResolver", "fillModuleResources"));
        }
        if (repository == null) {
            return;
        }
        for (StyleResourceValue value : this.getThemes(repository.getConfiguredResources(ResourceType.STYLE, this.myConfiguration.getFullConfig()), false)) {
            sink.add((Pair<StyleResourceValue, Module>)Pair.create((Object)value, (Object)module));
        }
    }

    @NotNull
    private List<StyleResourceValue> getThemes(@NotNull ResourceValueMap styles, boolean isFramework) {
        if (styles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styles", "com/android/tools/idea/editors/theme/ThemeResolver", "getThemes"));
        }
        Collection values = styles.values();
        ArrayList<StyleResourceValue> themes = new ArrayList<StyleResourceValue>(values.size());
        if (!isFramework) {
            HashMap cache = Maps.newHashMapWithExpectedSize((int)values.size());
            for (ResourceValue value : values) {
                StyleResourceValue styleValue;
                if (!(value instanceof StyleResourceValue) || !this.myResolver.isTheme((ResourceValue)(styleValue = (StyleResourceValue)value), (Map)cache)) continue;
                themes.add(styleValue);
            }
            ArrayList<StyleResourceValue> arrayList = themes;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getThemes"));
            }
            return arrayList;
        }
        for (ResourceValue value : values) {
            String name = value.getName();
            if (!name.startsWith("Theme.") && !name.equals("Theme")) continue;
            themes.add((StyleResourceValue)value);
        }
        ArrayList<StyleResourceValue> arrayList = themes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getThemes"));
        }
        return arrayList;
    }

    @Nullable
    public ConfiguredThemeEditorStyle getTheme(@NotNull String themeName) {
        if (themeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeName", "com/android/tools/idea/editors/theme/ThemeResolver", "getTheme"));
        }
        return this.myThemeByName.get(themeName);
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getLocalThemes() {
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = this.myLocalThemes;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getLocalThemes"));
        }
        return immutableList;
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getExternalLibraryThemes() {
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = this.myExternalLibraryThemes;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getExternalLibraryThemes"));
        }
        return immutableList;
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getFrameworkThemes() {
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = this.myFrameworkThemes;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getFrameworkThemes"));
        }
        return immutableList;
    }

    public int getThemesCount() {
        return this.myFrameworkThemes.size() + this.myExternalLibraryThemes.size() + this.myLocalThemes.size();
    }

    @NotNull
    Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeResolver", "getConfiguration"));
        }
        return configuration;
    }
}

