/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.qualifiers;

import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.ResourceEnum;
import com.android.tools.idea.editors.theme.qualifiers.QualifierUtils;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedQualifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestrictedEnum
implements RestrictedQualifier {
    private final Class<? extends ResourceEnum> myEnumClass;
    private final EnumSet<? extends ResourceEnum> myPossibleValues;

    public RestrictedEnum(@NotNull Class<? extends ResourceEnum> enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClass", "com/android/tools/idea/editors/theme/qualifiers/RestrictedEnum", "<init>"));
        }
        this.myPossibleValues = EnumSet.copyOf(Arrays.asList(enumClass.getEnumConstants()));
        this.myEnumClass = enumClass;
    }

    @NotNull
    private static ResourceEnum getValue(@NotNull ResourceQualifier qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/android/tools/idea/editors/theme/qualifiers/RestrictedEnum", "getValue"));
        }
        ResourceEnum resourceEnum = (ResourceEnum)QualifierUtils.getValue(qualifier);
        if (resourceEnum == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/qualifiers/RestrictedEnum", "getValue"));
        }
        return resourceEnum;
    }

    @Override
    public void setRestrictions(@Nullable ResourceQualifier compatible, @NotNull Collection<ResourceQualifier> incompatibles) {
        if (incompatibles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incompatibles", "com/android/tools/idea/editors/theme/qualifiers/RestrictedEnum", "setRestrictions"));
        }
        if (ResourceQualifier.isValid((ResourceQualifier)compatible)) {
            this.myPossibleValues.clear();
            this.myPossibleValues.addAll(Collections.singletonList(RestrictedEnum.getValue(compatible)));
        } else {
            for (ResourceQualifier qualifier : incompatibles) {
                if (!qualifier.isValid()) continue;
                this.myPossibleValues.remove(RestrictedEnum.getValue(qualifier));
            }
        }
    }

    @Override
    public boolean isMatchFor(@Nullable ResourceQualifier qualifier) {
        if (!ResourceQualifier.isValid((ResourceQualifier)qualifier)) {
            return false;
        }
        return this.myPossibleValues.contains(RestrictedEnum.getValue(qualifier));
    }

    @Override
    public boolean isEmpty() {
        return this.myPossibleValues.isEmpty();
    }

    @Override
    @Nullable
    public Object getAny() {
        assert (!this.myPossibleValues.isEmpty());
        if (this.myEnumClass.getEnumConstants().length == this.myPossibleValues.size()) {
            return null;
        }
        return this.myPossibleValues.iterator().next();
    }

    @Override
    @Nullable
    public RestrictedQualifier intersect(@NotNull RestrictedQualifier otherRestricted) {
        if (otherRestricted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherRestricted", "com/android/tools/idea/editors/theme/qualifiers/RestrictedEnum", "intersect"));
        }
        assert (otherRestricted instanceof RestrictedEnum);
        RestrictedEnum otherRestrictedEnum = (RestrictedEnum)otherRestricted;
        assert (this.myEnumClass.equals(otherRestrictedEnum.myEnumClass));
        RestrictedEnum result = new RestrictedEnum(this.myEnumClass);
        result.myPossibleValues.retainAll(this.myPossibleValues);
        result.myPossibleValues.retainAll(otherRestrictedEnum.myPossibleValues);
        if (result.myPossibleValues.isEmpty()) {
            return null;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictedEnum that = (RestrictedEnum)o;
        if (!this.myPossibleValues.equals(that.myPossibleValues)) {
            return false;
        }
        return this.myEnumClass.equals(that.myEnumClass);
    }

    public int hashCode() {
        int result = this.myPossibleValues.hashCode();
        result = 31 * result + this.myEnumClass.hashCode();
        return result;
    }
}

