/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.actions;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.fd.gradle.InstantRunGradleSupport;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HotswapAction
extends AndroidStudioGradleAction
implements AnAction.TransparentUpdate {
    public HotswapAction() {
        super("Apply Changes", "Apply Changes", AndroidIcons.RunIcons.HotReload, true);
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/fd/actions/HotswapAction", "doUpdate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/actions/HotswapAction", "doUpdate"));
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        if (!InstantRunSettings.isInstantRunEnabled()) {
            presentation.setText("Apply Changes: Instant Run has been disabled");
            return;
        }
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (settings == null) {
            presentation.setText("Apply Changes: No run configuration selected");
            return;
        }
        AndroidSessionInfo session = HotswapAction.getAndroidSessionInfo(project, settings);
        if (session == null) {
            presentation.setText(String.format("Apply Changes: No active '%1$s' launch", settings.getName()));
            return;
        }
        ProcessHandler processHandler = HotswapAction.getActiveProcessHandler(project, settings);
        if (processHandler == null) {
            presentation.setText(String.format("Apply Changes: No active '%1$s' launch", settings.getName()));
            return;
        }
        RunConfiguration configuration = settings.getConfiguration();
        if (!(configuration instanceof ModuleBasedConfiguration)) {
            presentation.setText(String.format("Apply Changes: '%1$s' is not a module based configuration", settings.getName()));
            return;
        }
        Module module = ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule();
        if (module == null) {
            presentation.setText(String.format("Apply Changes: No module specified in '%1$s'", settings.getName()));
            return;
        }
        if (!(configuration instanceof AndroidRunConfigurationBase)) {
            presentation.setText(String.format("Apply Changes: '%1$s' is not an Android launch configuration", settings.getName()));
            return;
        }
        if (!((AndroidRunConfigurationBase)configuration).supportsInstantRun()) {
            presentation.setText(String.format("Apply Changes: Configuration '%1$s' does not support instant run", settings.getName()));
            return;
        }
        AndroidVersion androidVersion = InstantRunManager.getMinDeviceApiLevel(processHandler);
        if (androidVersion == null) {
            presentation.setText(String.format("Apply Changes: Cannot locate device from '%1$s'", settings.getName()));
            return;
        }
        if (!InstantRunManager.isInstantRunCapableDeviceVersion(androidVersion)) {
            presentation.setText(String.format("Apply Changes: Target device API level (%1$s) too low for Instant Run", androidVersion));
            return;
        }
        InstantRunGradleSupport status = InstantRunGradleUtils.getIrSupportStatus(InstantRunGradleUtils.getAppModel(module), androidVersion);
        if (status != InstantRunGradleSupport.SUPPORTED) {
            String notification = status.getUserNotification();
            if (notification == null) {
                notification = status.toString();
            }
            presentation.setText("Apply Changes: " + notification);
            return;
        }
        presentation.setText("Apply Changes" + HotswapAction.getShortcutText());
        presentation.setEnabled(true);
    }

    @Nullable
    private static String getShortcutText() {
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = activeKeymap.getShortcuts("Android.HotswapChanges");
        return shortcuts.length > 0 ? " (" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + ") " : "";
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/fd/actions/HotswapAction", "doPerform"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/actions/HotswapAction", "doPerform"));
        }
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (settings == null) {
            InstantRunManager.LOG.warn("Hotswap Action could not locate current run config settings");
            return;
        }
        AndroidSessionInfo session = HotswapAction.getAndroidSessionInfo(project, settings);
        if (session == null) {
            InstantRunManager.LOG.warn("Hotswap Action could not locate an existing session for selected run config.");
            return;
        }
        Executor executor = HotswapAction.getExecutor(session.getExecutorId());
        if (executor == null) {
            InstantRunManager.LOG.warn("Hotswap Action could not identify executor");
            return;
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)settings);
        if (builder == null) {
            InstantRunManager.LOG.warn("Hotswap Action could not construct an env");
            return;
        }
        ExecutionEnvironment env = builder.activeTarget().dataContext(e.getDataContext()).build();
        InstantRunUtils.setInvokedViaHotswapAction(env, true);
        InstantRunManager.LOG.info("Invoking hotswap launch");
        ProgramRunnerUtil.executeConfiguration((ExecutionEnvironment)env, (boolean)false, (boolean)true);
    }

    @Nullable
    private static ProcessHandler getActiveProcessHandler(@Nullable Project project, @Nullable RunnerAndConfigurationSettings settings) {
        if (project == null || settings == null) {
            return null;
        }
        AndroidSessionInfo session = HotswapAction.getAndroidSessionInfo(project, settings);
        if (session == null) {
            return null;
        }
        ProcessHandler processHandler = session.getProcessHandler();
        if (processHandler.isProcessTerminated() || processHandler.isProcessTerminating()) {
            return null;
        }
        return processHandler;
    }

    @Nullable
    private static AndroidSessionInfo getAndroidSessionInfo(Project project, RunnerAndConfigurationSettings settings) {
        AndroidSessionInfo session = AndroidSessionInfo.findOldSession(project, null, settings.getConfiguration().getUniqueID());
        if (session == null) {
            return null;
        }
        return session;
    }

    @Nullable
    private static Executor getExecutor(@NotNull String executorId) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/android/tools/idea/fd/actions/HotswapAction", "getExecutor"));
        }
        for (Executor executor : (Executor[])Executor.EXECUTOR_EXTENSION_NAME.getExtensions()) {
            if (!executorId.equals(executor.getId())) continue;
            return executor;
        }
        return null;
    }
}

