/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.android.AdbOptionsDslElement;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbOptionsModel
extends GradleDslBlockModel {
    @NonNls
    private static final String INSTALL_OPTIONS = "installOptions";
    @NonNls
    private static final String TIME_OUT_IN_MS = "timeOutInMs";

    public AdbOptionsModel(@NotNull AdbOptionsDslElement dslElement) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/android/AdbOptionsModel", "<init>"));
        }
        super(dslElement);
    }

    @Nullable
    public List<GradleNotNullValue<String>> installOptions() {
        return this.myDslElement.getListProperty(INSTALL_OPTIONS, String.class);
    }

    @NotNull
    public AdbOptionsModel addInstallOption(@NotNull String installOption) {
        if (installOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installOption", "com/android/tools/idea/gradle/dsl/model/android/AdbOptionsModel", "addInstallOption"));
        }
        this.myDslElement.addToNewLiteralList(INSTALL_OPTIONS, installOption);
        AdbOptionsModel adbOptionsModel = this;
        if (adbOptionsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AdbOptionsModel", "addInstallOption"));
        }
        return adbOptionsModel;
    }

    @NotNull
    public AdbOptionsModel removeInstallOption(@NotNull String installOption) {
        if (installOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installOption", "com/android/tools/idea/gradle/dsl/model/android/AdbOptionsModel", "removeInstallOption"));
        }
        this.myDslElement.removeFromExpressionList(INSTALL_OPTIONS, installOption);
        AdbOptionsModel adbOptionsModel = this;
        if (adbOptionsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AdbOptionsModel", "removeInstallOption"));
        }
        return adbOptionsModel;
    }

    @NotNull
    public AdbOptionsModel removeAllInstallOptions() {
        this.myDslElement.removeProperty(INSTALL_OPTIONS);
        AdbOptionsModel adbOptionsModel = this;
        if (adbOptionsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AdbOptionsModel", "removeAllInstallOptions"));
        }
        return adbOptionsModel;
    }

    @NotNull
    public AdbOptionsModel replaceInstallOption(@NotNull String oldInstallOption, @NotNull String newInstallOption) {
        if (oldInstallOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldInstallOption", "com/android/tools/idea/gradle/dsl/model/android/AdbOptionsModel", "replaceInstallOption"));
        }
        if (newInstallOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newInstallOption", "com/android/tools/idea/gradle/dsl/model/android/AdbOptionsModel", "replaceInstallOption"));
        }
        this.myDslElement.replaceInExpressionList(INSTALL_OPTIONS, oldInstallOption, newInstallOption);
        AdbOptionsModel adbOptionsModel = this;
        if (adbOptionsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AdbOptionsModel", "replaceInstallOption"));
        }
        return adbOptionsModel;
    }

    @NotNull
    public GradleNullableValue<Integer> timeOutInMs() {
        GradleNullableValue<Integer> gradleNullableValue = this.myDslElement.getLiteralProperty(TIME_OUT_IN_MS, Integer.class);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AdbOptionsModel", TIME_OUT_IN_MS));
        }
        return gradleNullableValue;
    }

    @NotNull
    public AdbOptionsModel setTimeOutInMs(int timeOutInMs) {
        this.myDslElement.setNewLiteral(TIME_OUT_IN_MS, timeOutInMs);
        AdbOptionsModel adbOptionsModel = this;
        if (adbOptionsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AdbOptionsModel", "setTimeOutInMs"));
        }
        return adbOptionsModel;
    }

    @NotNull
    public AdbOptionsModel removeTimeOutInMs() {
        this.myDslElement.removeProperty(TIME_OUT_IN_MS);
        AdbOptionsModel adbOptionsModel = this;
        if (adbOptionsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AdbOptionsModel", "removeTimeOutInMs"));
        }
        return adbOptionsModel;
    }
}

