/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.plugin;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.util.BuildFileProcessor;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPluginVersionUpdater {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final GradleSyncInvoker mySyncInvoker;
    @NotNull
    private final TextSearch myTextSearch;

    @NotNull
    public static AndroidPluginVersionUpdater getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "getInstance"));
        }
        AndroidPluginVersionUpdater androidPluginVersionUpdater = (AndroidPluginVersionUpdater)ServiceManager.getService((Project)project, AndroidPluginVersionUpdater.class);
        if (androidPluginVersionUpdater == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "getInstance"));
        }
        return androidPluginVersionUpdater;
    }

    public AndroidPluginVersionUpdater(@NotNull Project project, @NotNull GradleSyncState syncState) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "<init>"));
        }
        if (syncState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncState", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "<init>"));
        }
        this(project, syncState, GradleSyncInvoker.getInstance(), new TextSearch(project));
    }

    @VisibleForTesting
    AndroidPluginVersionUpdater(@NotNull Project project, @NotNull GradleSyncState syncState, @NotNull GradleSyncInvoker syncInvoker, @NotNull TextSearch textSearch) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "<init>"));
        }
        if (syncState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncState", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "<init>"));
        }
        if (syncInvoker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncInvoker", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "<init>"));
        }
        if (textSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textSearch", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "<init>"));
        }
        this.myProject = project;
        this.mySyncState = syncState;
        this.mySyncInvoker = syncInvoker;
        this.myTextSearch = textSearch;
    }

    public UpdateResult updatePluginVersionAndSync(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion, boolean invalidateLastSyncOnFailure) {
        String msg;
        if (pluginVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginVersion", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "updatePluginVersionAndSync"));
        }
        UpdateResult result = this.updatePluginVersion(pluginVersion, gradleVersion);
        Throwable pluginVersionUpdateError = result.getPluginVersionUpdateError();
        Throwable gradleVersionUpdateError = result.getGradleVersionUpdateError();
        if (pluginVersionUpdateError != null) {
            msg = String.format("Failed to update Android plugin to version '%1$s'", pluginVersion);
            AndroidPluginVersionUpdater.logUpdateError(msg, pluginVersionUpdateError);
        }
        if (gradleVersionUpdateError != null) {
            msg = String.format("Failed to update Gradle to version '%1$s'", gradleVersion);
            AndroidPluginVersionUpdater.logUpdateError(msg, gradleVersionUpdateError);
        }
        this.handleUpdateResult(result, invalidateLastSyncOnFailure);
        return result;
    }

    @VisibleForTesting
    void handleUpdateResult(@NotNull UpdateResult result, boolean invalidateLastSyncOnFailure) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "handleUpdateResult"));
        }
        Throwable pluginVersionUpdateError = result.getPluginVersionUpdateError();
        if (pluginVersionUpdateError != null || result.getGradleVersionUpdateError() != null) {
            if (invalidateLastSyncOnFailure) {
                this.mySyncState.invalidateLastSync("Failed to update either Android plugin version or Gradle version");
            }
            if (pluginVersionUpdateError != null) {
                this.myTextSearch.execute();
            }
        } else if (result.isPluginVersionUpdated() || result.isGradleVersionUpdated()) {
            this.mySyncState.syncEnded();
            GradleSyncInvoker.Request request = new GradleSyncInvoker.Request().setCleanProject(true);
            this.mySyncInvoker.requestProjectSync(this.myProject, request, null);
        }
    }

    private static void logUpdateError(@NotNull String msg, @NotNull Throwable error) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "logUpdateError"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "logUpdateError"));
        }
        String cause = error.getMessage();
        if (StringUtil.isNotEmpty((String)cause)) {
            msg = msg + ": " + cause;
        }
        Logger.getInstance(AndroidPluginVersionUpdater.class).warn(msg);
    }

    @NotNull
    public UpdateResult updatePluginVersion(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion) {
        String basePath;
        boolean updateModels;
        if (pluginVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginVersion", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "updatePluginVersion"));
        }
        final ArrayList modelsToUpdate = Lists.newArrayList();
        BuildFileProcessor.getInstance().processRecursively(this.myProject, (Processor<GradleBuildModel>)((Processor)buildModel -> {
            if (pluginVersion == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginVersion", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "lambda$updatePluginVersion$0"));
            }
            DependenciesModel dependencies = buildModel.buildscript().dependencies();
            for (ArtifactDependencyModel dependency : dependencies.artifacts("classpath")) {
                String groupId;
                String artifactId = dependency.name().value();
                if (AndroidPluginGeneration.find(artifactId, groupId = (String)dependency.group().value()) == null) continue;
                String versionValue = (String)dependency.version().value();
                if (!StringUtil.isEmpty((String)versionValue) && pluginVersion.compareTo(versionValue) == 0) break;
                dependency.setVersion(pluginVersion.toString());
                modelsToUpdate.add(buildModel);
                break;
            }
            return true;
        }));
        final UpdateResult result = new UpdateResult();
        boolean bl = updateModels = !modelsToUpdate.isEmpty();
        if (updateModels) {
            try {
                WriteCommandAction.runWriteCommandAction((Project)this.myProject, (ThrowableComputable)new ThrowableComputable<Void, RuntimeException>(){

                    public Void compute() {
                        for (GradleBuildModel buildModel : modelsToUpdate) {
                            buildModel.applyChanges();
                        }
                        result.pluginVersionUpdated();
                        return null;
                    }
                });
            }
            catch (Throwable e) {
                result.setPluginVersionUpdateError(e);
            }
        }
        if (gradleVersion != null && (basePath = this.myProject.getBasePath()) != null) {
            try {
                File wrapperPropertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(new File(basePath));
                GradleWrapper gradleWrapper = GradleWrapper.get(wrapperPropertiesFilePath);
                String current = gradleWrapper.getGradleVersion();
                GradleVersion parsedCurrent = null;
                if (current != null) {
                    parsedCurrent = GradleVersion.tryParse((String)current);
                }
                if (parsedCurrent != null && !GradleUtil.isSupportedGradleVersion(parsedCurrent)) {
                    gradleWrapper.updateDistributionUrl(gradleVersion.toString());
                    result.gradleVersionUpdated();
                }
            }
            catch (Throwable e) {
                result.setGradleVersionUpdateError(e);
            }
        }
        UpdateResult updateResult = result;
        if (updateResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater", "updatePluginVersion"));
        }
        return updateResult;
    }

    @VisibleForTesting
    static class TextSearch {
        @NotNull
        private final Project myProject;

        TextSearch(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater$TextSearch", "<init>"));
            }
            this.myProject = project;
        }

        void execute() {
            String msg = "Failed to update the version of the Android Gradle plugin.\n\nPlease click 'OK' to perform a textual search and then update the build files manually.";
            Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Unexpected Error");
            String textToFind = AndroidPluginGeneration.getGroupId() + ":" + AndroidPluginGeneration.ORIGINAL.getArtifactId();
            SearchInBuildFilesHyperlink.searchInBuildFiles(textToFind, this.myProject);
        }
    }

    public static class UpdateResult {
        @Nullable
        private Throwable myPluginVersionUpdateError;
        @Nullable
        private Throwable myGradleVersionUpdateError;
        private boolean myPluginVersionUpdated;
        private boolean myGradleVersionUpdated;

        UpdateResult() {
        }

        @Nullable
        public Throwable getPluginVersionUpdateError() {
            return this.myPluginVersionUpdateError;
        }

        void setPluginVersionUpdateError(@NotNull Throwable error) {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater$UpdateResult", "setPluginVersionUpdateError"));
            }
            this.myPluginVersionUpdateError = error;
        }

        @Nullable
        public Throwable getGradleVersionUpdateError() {
            return this.myGradleVersionUpdateError;
        }

        void setGradleVersionUpdateError(@NotNull Throwable error) {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater$UpdateResult", "setGradleVersionUpdateError"));
            }
            this.myGradleVersionUpdateError = error;
        }

        public boolean isPluginVersionUpdated() {
            return this.myPluginVersionUpdated;
        }

        void pluginVersionUpdated() {
            this.myPluginVersionUpdated = true;
        }

        public boolean isGradleVersionUpdated() {
            return this.myGradleVersionUpdated;
        }

        void gradleVersionUpdated() {
            this.myGradleVersionUpdated = true;
        }

        public boolean versionUpdateSuccess() {
            return (this.myPluginVersionUpdated || this.myGradleVersionUpdated) && this.myPluginVersionUpdateError == null && this.myGradleVersionUpdateError == null;
        }
    }
}

