/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.importing.NewProjectImportGradleSyncListener;
import com.android.tools.idea.gradle.project.importing.NewProjectSetup;
import com.android.tools.idea.gradle.project.importing.ProjectFolder;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.SdkSync;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.project.NewProjects;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleProjectImporter {
    @NotNull
    private final SdkSync mySdkSync;
    @NotNull
    private final GradleSyncInvoker myGradleSyncInvoker;
    @NotNull
    private final NewProjectSetup myNewProjectSetup;
    @NotNull
    private final ProjectFolder.Factory myProjectFolderFactory;
    public static boolean ourSkipSetupFromTest;

    @NotNull
    public static GradleProjectImporter getInstance() {
        GradleProjectImporter gradleProjectImporter = (GradleProjectImporter)ServiceManager.getService(GradleProjectImporter.class);
        if (gradleProjectImporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "getInstance"));
        }
        return gradleProjectImporter;
    }

    public GradleProjectImporter(@NotNull SdkSync sdkSync, @NotNull GradleSyncInvoker gradleSyncInvoker) {
        if (sdkSync == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkSync", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "<init>"));
        }
        if (gradleSyncInvoker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleSyncInvoker", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "<init>"));
        }
        this(sdkSync, gradleSyncInvoker, new NewProjectSetup(), new ProjectFolder.Factory());
    }

    @VisibleForTesting
    GradleProjectImporter(@NotNull SdkSync sdkSync, @NotNull GradleSyncInvoker gradleSyncInvoker, @NotNull NewProjectSetup newProjectSetup, @NotNull ProjectFolder.Factory projectFolderFactory) {
        if (sdkSync == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkSync", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "<init>"));
        }
        if (gradleSyncInvoker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleSyncInvoker", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "<init>"));
        }
        if (newProjectSetup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newProjectSetup", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "<init>"));
        }
        if (projectFolderFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFolderFactory", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "<init>"));
        }
        this.mySdkSync = sdkSync;
        this.myGradleSyncInvoker = gradleSyncInvoker;
        this.myNewProjectSetup = newProjectSetup;
        this.myProjectFolderFactory = projectFolderFactory;
    }

    public void openProject(@NotNull VirtualFile selectedFile) {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "openProject"));
        }
        this.openOrImportProject(selectedFile, true);
    }

    public void importProject(@NotNull VirtualFile selectedFile) {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "importProject"));
        }
        this.openOrImportProject(selectedFile, false);
    }

    private void openOrImportProject(@NotNull VirtualFile selectedFile, boolean open) {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "openOrImportProject"));
        }
        VirtualFile projectFolder = GradleProjectImporter.findProjectFolder(selectedFile);
        File projectFolderPath = VfsUtilCore.virtualToIoFile((VirtualFile)projectFolder);
        try {
            this.setUpLocalProperties(projectFolderPath);
        }
        catch (IOException e) {
            return;
        }
        try {
            String projectName = projectFolder.getName();
            this.openOrImportProject(projectName, projectFolderPath, Request.EMPTY_REQUEST, GradleProjectImporter.createNewProjectListener(projectFolder), open);
        }
        catch (Throwable e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
            }
            Messages.showErrorDialog((String)e.getMessage(), (String)(open ? "Open Project" : "Project Import"));
            this.getLogger().error(e);
        }
    }

    @NotNull
    private static VirtualFile findProjectFolder(@NotNull VirtualFile selectedFile) {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "findProjectFolder"));
        }
        VirtualFile virtualFile = selectedFile.isDirectory() ? selectedFile : selectedFile.getParent();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "findProjectFolder"));
        }
        return virtualFile;
    }

    private void setUpLocalProperties(@NotNull File projectFolderPath) throws IOException {
        if (projectFolderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFolderPath", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "setUpLocalProperties"));
        }
        try {
            LocalProperties localProperties = new LocalProperties(projectFolderPath);
            if (IdeInfo.getInstance().isAndroidStudio()) {
                this.mySdkSync.syncIdeAndProjectAndroidSdks(localProperties);
            }
        }
        catch (IOException e) {
            this.getLogger().info("Failed to sync SDKs", (Throwable)e);
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            throw e;
        }
    }

    @NotNull
    private Logger getLogger() {
        Logger logger = Logger.getInstance(this.getClass());
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "getLogger"));
        }
        return logger;
    }

    @NotNull
    private static NewProjectImportGradleSyncListener createNewProjectListener(final @NotNull VirtualFile projectFolder) {
        if (projectFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFolder", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "createNewProjectListener"));
        }
        NewProjectImportGradleSyncListener newProjectImportGradleSyncListener = new NewProjectImportGradleSyncListener(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter$1", "syncSucceeded"));
                }
                FileChooserUtil.setLastOpenedFile((Project)project, (VirtualFile)projectFolder);
                ProjectUtil.focusProjectWindow((Project)project, (boolean)false);
                NewProjects.activateProjectView(project);
            }
        };
        if (newProjectImportGradleSyncListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "createNewProjectListener"));
        }
        return newProjectImportGradleSyncListener;
    }

    public void importProject(@NotNull String projectName, @NotNull File projectFolderPath, @Nullable GradleSyncListener listener) throws IOException, ConfigurationException {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "importProject"));
        }
        if (projectFolderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFolderPath", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "importProject"));
        }
        this.importProject(projectName, projectFolderPath, Request.EMPTY_REQUEST, listener);
    }

    public void importProject(@NotNull String projectName, @NotNull File projectFolderPath, @NotNull Request request, @Nullable GradleSyncListener listener) throws IOException, ConfigurationException {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "importProject"));
        }
        if (projectFolderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFolderPath", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "importProject"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "importProject"));
        }
        this.openOrImportProject(projectName, projectFolderPath, request, listener, false);
    }

    private void openOrImportProject(@NotNull String projectName, @NotNull File projectFolderPath, @NotNull Request request, @Nullable GradleSyncListener listener, boolean open) throws IOException, ConfigurationException {
        Project project;
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "openOrImportProject"));
        }
        if (projectFolderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFolderPath", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "openOrImportProject"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "openOrImportProject"));
        }
        ProjectFolder projectFolder = this.myProjectFolderFactory.create(projectFolderPath);
        projectFolder.createTopLevelBuildFile();
        projectFolder.createIdeaProjectFolder();
        Project newProject = project = request.getProject();
        if (newProject == null) {
            Project project2 = newProject = open ? this.myNewProjectSetup.openProject(projectFolderPath.getPath()) : this.myNewProjectSetup.createProject(projectName, projectFolderPath.getPath());
        }
        if (project == null) {
            GradleSettings gradleSettings = GradleSettings.getInstance((Project)newProject);
            gradleSettings.setGradleVmOptions("");
        }
        this.myNewProjectSetup.prepareProjectForImport(newProject, request.getLanguageLevel());
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            newProject.save();
        }
        this.myGradleSyncInvoker.requestProjectSync(newProject, GradleProjectImporter.createSyncRequestSettings(request), listener);
    }

    @VisibleForTesting
    @NotNull
    static GradleSyncInvoker.Request createSyncRequestSettings(@NotNull Request importProjectSettings) {
        if (importProjectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importProjectSettings", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "createSyncRequestSettings"));
        }
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request();
        request.setGenerateSourcesOnSuccess(importProjectSettings.isGenerateSourcesOnSuccess()).setRunInBackground(false).setUseCachedGradleModels(false).setNewProject(true);
        GradleSyncInvoker.Request request2 = request;
        if (request2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter", "createSyncRequestSettings"));
        }
        return request2;
    }

    public static class Request {
        @NotNull
        private static final Request EMPTY_REQUEST = new Request();
        @Nullable
        private Project myProject;
        @Nullable
        private LanguageLevel myLanguageLevel;
        private boolean myGenerateSourcesOnSuccess = true;

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public Request setProject(@Nullable Project project) {
            this.myProject = project;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter$Request", "setProject"));
            }
            return request;
        }

        @Nullable
        public LanguageLevel getLanguageLevel() {
            return this.myLanguageLevel;
        }

        @NotNull
        public Request setLanguageLevel(@Nullable LanguageLevel languageLevel) {
            this.myLanguageLevel = languageLevel;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter$Request", "setLanguageLevel"));
            }
            return request;
        }

        public boolean isGenerateSourcesOnSuccess() {
            return this.myGenerateSourcesOnSuccess;
        }

        @NotNull
        public Request setGenerateSourcesOnSuccess(boolean generateSourcesOnSuccess) {
            this.myGenerateSourcesOnSuccess = generateSourcesOnSuccess;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/importing/GradleProjectImporter$Request", "setGenerateSourcesOnSuccess"));
            }
            return request;
        }
    }
}

