/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleModuleModel
implements ModuleModel {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final List<String> myTaskNames;
    @NotNull
    private final String myGradlePath;
    @Nullable
    private final File myBuildFilePath;
    @Nullable
    private final String myGradleVersion;

    public GradleModuleModel(@NotNull String moduleName, @NotNull GradleProject gradleProject, @Nullable File buildFilePath, @Nullable String gradleVersion) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/project/model/GradleModuleModel", "<init>"));
        }
        if (gradleProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleProject", "com/android/tools/idea/gradle/project/model/GradleModuleModel", "<init>"));
        }
        this(moduleName, GradleModuleModel.getTaskNames(gradleProject), gradleProject.getPath(), buildFilePath, gradleVersion);
    }

    @NotNull
    private static List<String> getTaskNames(@NotNull GradleProject gradleProject) {
        if (gradleProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleProject", "com/android/tools/idea/gradle/project/model/GradleModuleModel", "getTaskNames"));
        }
        ArrayList<String> taskNames = new ArrayList<String>();
        DomainObjectSet tasks = gradleProject.getTasks();
        if (!tasks.isEmpty()) {
            for (GradleTask task : tasks) {
                String name = task.getName();
                if (!StringUtil.isNotEmpty((String)name)) continue;
                taskNames.add(task.getProject().getPath() + ":" + task.getName());
            }
        }
        ArrayList<String> arrayList = taskNames;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/GradleModuleModel", "getTaskNames"));
        }
        return arrayList;
    }

    public GradleModuleModel(@NotNull String moduleName, @NotNull List<String> taskNames, @NotNull String gradlePath, @Nullable File buildFilePath, @Nullable String gradleVersion) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/project/model/GradleModuleModel", "<init>"));
        }
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNames", "com/android/tools/idea/gradle/project/model/GradleModuleModel", "<init>"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/project/model/GradleModuleModel", "<init>"));
        }
        this.myModuleName = moduleName;
        this.myTaskNames = taskNames;
        this.myGradlePath = gradlePath;
        this.myBuildFilePath = buildFilePath;
        this.myGradleVersion = gradleVersion;
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/GradleModuleModel", "getModuleName"));
        }
        return string;
    }

    @NotNull
    public String getGradlePath() {
        String string = this.myGradlePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/GradleModuleModel", "getGradlePath"));
        }
        return string;
    }

    @NotNull
    public List<String> getTaskNames() {
        List<String> list = this.myTaskNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/GradleModuleModel", "getTaskNames"));
        }
        return list;
    }

    @Nullable
    public VirtualFile getBuildFile() {
        return this.myBuildFilePath != null ? VfsUtil.findFileByIoFile((File)this.myBuildFilePath, (boolean)true) : null;
    }

    @Nullable
    public File getBuildFilePath() {
        return this.myBuildFilePath;
    }

    @Nullable
    public String getGradleVersion() {
        return this.myGradleVersion;
    }
}

