/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenProjectStructureHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DaemonContextMismatchErrorHandler
extends BaseSyncErrorHandler {
    private static final String JAVA_HOME = "javaHome=";

    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull NotificationData notification, @NotNull Project project) {
        String expectedAndActual;
        if (rootCause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCause", "com/android/tools/idea/gradle/project/sync/errors/DaemonContextMismatchErrorHandler", "findErrorMessage"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/DaemonContextMismatchErrorHandler", "findErrorMessage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/DaemonContextMismatchErrorHandler", "findErrorMessage"));
        }
        String text = rootCause.getMessage();
        List message = Splitter.on((char)'\n').omitEmptyStrings().trimResults().splitToList((CharSequence)text);
        String firstLine = (String)message.get(0);
        if (StringUtil.isNotEmpty((String)firstLine) && firstLine.contains("The newly created daemon process has a different context than expected.") && message.size() > 3 && "Java home is different.".equals(message.get(2)) && StringUtil.isNotEmpty((String)(expectedAndActual = DaemonContextMismatchErrorHandler.parseExpectedAndActualJavaHomes(text)))) {
            DaemonContextMismatchErrorHandler.updateUsageTracker();
            return firstLine + "\n" + (String)message.get(2) + "\n" + expectedAndActual + "\nPlease configure the JDK to match the expected one.";
        }
        return null;
    }

    @VisibleForTesting
    static String parseExpectedAndActualJavaHomes(@NotNull String errorMsg) {
        String expected;
        int endIndex;
        if (errorMsg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMsg", "com/android/tools/idea/gradle/project/sync/errors/DaemonContextMismatchErrorHandler", "parseExpectedAndActualJavaHomes"));
        }
        int startIndex = errorMsg.indexOf(JAVA_HOME);
        if (startIndex != -1 && (endIndex = errorMsg.indexOf(44, startIndex += JAVA_HOME.length())) != -1 && endIndex > startIndex && StringUtil.isNotEmpty((String)(expected = errorMsg.substring(startIndex, endIndex)))) {
            String actual = null;
            startIndex = errorMsg.indexOf(JAVA_HOME, endIndex);
            if (startIndex != -1 && (endIndex = errorMsg.indexOf(44, startIndex += JAVA_HOME.length())) != -1 && endIndex > startIndex) {
                actual = errorMsg.substring(startIndex, endIndex);
            }
            String s = String.format("Expecting: '%1$s'", expected);
            s = actual != null ? s + String.format(" but was: '%1$s'.", actual) : s + ".";
            return s;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/DaemonContextMismatchErrorHandler", "getQuickFixHyperlinks"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/DaemonContextMismatchErrorHandler", "getQuickFixHyperlinks"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/errors/DaemonContextMismatchErrorHandler", "getQuickFixHyperlinks"));
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(OpenProjectStructureHyperlink.openJdkSettings(project));
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/DaemonContextMismatchErrorHandler", "getQuickFixHyperlinks"));
        }
        return arrayList;
    }
}

