/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OpenFileHyperlink
extends NotificationHyperlink {
    @NotNull
    private final String myFilePath;
    private final int myLineNumber;
    private final int myColumn;

    public OpenFileHyperlink(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/idea/gradle/project/sync/hyperlink/OpenFileHyperlink", "<init>"));
        }
        this(filePath, -1);
    }

    public OpenFileHyperlink(@NotNull String filePath, int lineNumber) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/idea/gradle/project/sync/hyperlink/OpenFileHyperlink", "<init>"));
        }
        this(filePath, "Open File", lineNumber, -1);
    }

    public OpenFileHyperlink(@NotNull String filePath, @NotNull String text, int lineNumber, int column) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/idea/gradle/project/sync/hyperlink/OpenFileHyperlink", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/hyperlink/OpenFileHyperlink", "<init>"));
        }
        super("openFile:" + filePath, text);
        this.myFilePath = FileUtil.toSystemIndependentName((String)filePath);
        this.myLineNumber = lineNumber;
        this.myColumn = column;
    }

    @Override
    protected void execute(@NotNull Project project) {
        OpenFileDescriptor openFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/OpenFileHyperlink", "execute"));
        }
        VirtualFile projectFile = project.getProjectFile();
        if (projectFile == null) {
            return;
        }
        VirtualFile file = projectFile.getParent().getFileSystem().findFileByPath(this.myFilePath);
        if (file != null && (openFile = new OpenFileDescriptor(project, file, this.myLineNumber, this.myColumn, false)).canNavigate()) {
            openFile.navigate(true);
        }
    }

    @VisibleForTesting
    @NotNull
    public String getFilePath() {
        String string = this.myFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/hyperlink/OpenFileHyperlink", "getFilePath"));
        }
        return string;
    }

    @VisibleForTesting
    public int getLineNumber() {
        return this.myLineNumber;
    }
}

