/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.idea.data.model.ProjectCleanupModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectCleanup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectCleanupDataService
extends AbstractProjectDataService<ProjectCleanupModel, Void> {
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final ProjectCleanup myProjectCleanup;

    public ProjectCleanupDataService(@NotNull IdeInfo ideInfo) {
        if (ideInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideInfo", "com/android/tools/idea/gradle/project/sync/idea/data/service/ProjectCleanupDataService", "<init>"));
        }
        this(ideInfo, new ProjectCleanup());
    }

    @VisibleForTesting
    ProjectCleanupDataService(@NotNull IdeInfo ideInfo, @NotNull ProjectCleanup projectCleanup) {
        if (ideInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideInfo", "com/android/tools/idea/gradle/project/sync/idea/data/service/ProjectCleanupDataService", "<init>"));
        }
        if (projectCleanup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectCleanup", "com/android/tools/idea/gradle/project/sync/idea/data/service/ProjectCleanupDataService", "<init>"));
        }
        this.myIdeInfo = ideInfo;
        this.myProjectCleanup = projectCleanup;
    }

    @NotNull
    public Key<ProjectCleanupModel> getTargetDataKey() {
        Key<ProjectCleanupModel> key = AndroidProjectKeys.PROJECT_CLEANUP_MODEL;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/data/service/ProjectCleanupDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ProjectCleanupModel>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/project/sync/idea/data/service/ProjectCleanupDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/idea/data/service/ProjectCleanupDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/idea/data/service/ProjectCleanupDataService", "importData"));
        }
        if (toImport.isEmpty() || !this.myIdeInfo.isAndroidStudio()) {
            return;
        }
        if (!GradleSyncState.getInstance(project).lastSyncFailedOrHasIssues()) {
            this.myProjectCleanup.cleanUpProject(project, modelsProvider, null);
        }
    }
}

