/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.precheck;

import com.android.tools.idea.gradle.project.sync.precheck.AndroidSdkPreSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.JdkPreSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.gradle.project.sync.precheck.SyncCheck;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PreSyncChecks {
    @NotNull
    private final List<SyncCheck> myStrategies;

    @NotNull
    public static PreSyncChecks getInstance() {
        PreSyncChecks preSyncChecks = (PreSyncChecks)ServiceManager.getService(PreSyncChecks.class);
        if (preSyncChecks == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/precheck/PreSyncChecks", "getInstance"));
        }
        return preSyncChecks;
    }

    public PreSyncChecks() {
        this(new AndroidSdkPreSyncCheck(), new JdkPreSyncCheck());
    }

    @VisibleForTesting
    PreSyncChecks(SyncCheck ... strategies) {
        if (strategies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategies", "com/android/tools/idea/gradle/project/sync/precheck/PreSyncChecks", "<init>"));
        }
        this.myStrategies = Lists.newArrayList((Object[])strategies);
    }

    @NotNull
    public PreSyncCheckResult canSync(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/precheck/PreSyncChecks", "canSync"));
        }
        for (SyncCheck condition : this.myStrategies) {
            PreSyncCheckResult result = condition.canSync(project);
            if (result.isSuccess()) continue;
            PreSyncCheckResult preSyncCheckResult = result;
            if (preSyncCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/precheck/PreSyncChecks", "canSync"));
            }
            return preSyncCheckResult;
        }
        PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.SUCCESS;
        if (preSyncCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/precheck/PreSyncChecks", "canSync"));
        }
        return preSyncCheckResult;
    }

    @VisibleForTesting
    @NotNull
    List<SyncCheck> getStrategies() {
        List<SyncCheck> list = this.myStrategies;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/precheck/PreSyncChecks", "getStrategies"));
        }
        return list;
    }
}

