/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.annotations.NotNull;

public class AndroidModuleSetup {
    private final AndroidModuleSetupStep[] mySetupSteps;

    public AndroidModuleSetup() {
        this(AndroidModuleSetupStep.getExtensions());
    }

    @VisibleForTesting
    AndroidModuleSetup(AndroidModuleSetupStep[] setupSteps) {
        this.mySetupSteps = setupSteps;
    }

    public void setUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, AndroidModuleModel androidModel, SyncAction.ModuleModels models, ProgressIndicator indicator) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/AndroidModuleSetup", "setUpModule"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/AndroidModuleSetup", "setUpModule"));
        }
        for (AndroidModuleSetupStep step : this.mySetupSteps) {
            if (indicator != null) {
                step.displayDescription(module, indicator);
            }
            step.setUpModule(module, ideModelsProvider, androidModel, models, indicator);
        }
    }
}

