/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.cleanup;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallPlatformHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectCleanupStep;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.startup.ExternalAnnotationsSupport;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdksCleanupStep
extends ProjectCleanupStep {
    @NotNull
    private final AndroidSdks myAndroidSdks;

    public SdksCleanupStep(@NotNull AndroidSdks androidSdks) {
        if (androidSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdks", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/SdksCleanupStep", "<init>"));
        }
        this.myAndroidSdks = androidSdks;
    }

    @Override
    public void cleanUpProject(@NotNull Project project, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @Nullable com.intellij.openapi.progress.ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/SdksCleanupStep", "cleanUpProject"));
        }
        if (ideModifiableModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModifiableModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/SdksCleanupStep", "cleanUpProject"));
        }
        HashSet invalidAndroidSdks = Sets.newHashSet();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            this.cleanUpSdk(module, invalidAndroidSdks);
        }
        if (!invalidAndroidSdks.isEmpty()) {
            this.reinstallMissingPlatforms(invalidAndroidSdks, project);
        }
    }

    public void cleanUpSdk(@NotNull Module module, @NotNull Collection<Sdk> invalidAndroidSdks) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/SdksCleanupStep", "cleanUpSdk"));
        }
        if (invalidAndroidSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidAndroidSdks", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/SdksCleanupStep", "cleanUpSdk"));
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet == null || androidFacet.getAndroidModel() == null) {
            return;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null && !invalidAndroidSdks.contains(sdk) && (this.isMissingAndroidLibrary(sdk) || this.shouldRemoveAnnotationsJar(sdk))) {
            AndroidSdkAdditionalData additionalData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
            if (additionalData != null && sdkData != null) {
                IAndroidTarget target = additionalData.getBuildTarget(sdkData);
                if (target == null) {
                    AndroidSdkHandler sdkHandler = sdkData.getSdkHandler();
                    StudioLoggerProgressIndicator logger = new StudioLoggerProgressIndicator(this.getClass());
                    sdkHandler.getSdkManager((ProgressIndicator)logger).loadSynchronously(0L, (ProgressIndicator)logger, null, null);
                    target = sdkHandler.getAndroidTargetManager((ProgressIndicator)logger).getTargetFromHashString(additionalData.getBuildTargetHashString(), (ProgressIndicator)logger);
                }
                if (target != null) {
                    SdkModificator sdkModificator = sdk.getSdkModificator();
                    sdkModificator.removeAllRoots();
                    for (OrderRoot orderRoot : this.myAndroidSdks.getLibraryRootsForTarget(target, sdk, true)) {
                        sdkModificator.addRoot(orderRoot.getFile(), orderRoot.getType());
                    }
                    ExternalAnnotationsSupport.attachJdkAnnotations(sdkModificator);
                    sdkModificator.commitChanges();
                }
            }
            if (this.isMissingAndroidLibrary(sdk)) {
                invalidAndroidSdks.add(sdk);
            }
        }
    }

    private boolean isMissingAndroidLibrary(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/SdksCleanupStep", "isMissingAndroidLibrary"));
        }
        if (this.myAndroidSdks.isAndroidSdk(sdk)) {
            for (VirtualFile library : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!library.getName().equals("android.jar") || !library.exists()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean shouldRemoveAnnotationsJar(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/SdksCleanupStep", "shouldRemoveAnnotationsJar"));
        }
        if (this.myAndroidSdks.isAndroidSdk(sdk)) {
            IAndroidTarget target;
            AndroidSdkAdditionalData additionalData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
            boolean needsAnnotationsJar = false;
            if (additionalData != null && sdkData != null && (target = additionalData.getBuildTarget(sdkData)) != null) {
                needsAnnotationsJar = this.myAndroidSdks.needsAnnotationsJarInClasspath(target);
            }
            for (VirtualFile library : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!library.getName().equals("annotations.jar") || !library.exists() || needsAnnotationsJar) continue;
                return true;
            }
        }
        return false;
    }

    private void reinstallMissingPlatforms(@NotNull Collection<Sdk> invalidAndroidSdks, @NotNull Project project) {
        if (invalidAndroidSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidAndroidSdks", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/SdksCleanupStep", "reinstallMissingPlatforms"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/SdksCleanupStep", "reinstallMissingPlatforms"));
        }
        ArrayList versionsToInstall = Lists.newArrayList();
        ArrayList missingPlatforms = Lists.newArrayList();
        for (Sdk sdk : invalidAndroidSdks) {
            String platform;
            AndroidSdkAdditionalData additionalData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            if (additionalData == null || (platform = additionalData.getBuildTargetHashString()) == null) continue;
            missingPlatforms.add("'" + platform + "'");
            AndroidVersion version = AndroidTargetHash.getPlatformVersion((String)platform);
            if (version == null) continue;
            versionsToInstall.add(version);
        }
        if (!versionsToInstall.isEmpty()) {
            String text = "Missing Android platform(s) detected: " + Joiner.on((String)", ").join((Iterable)missingPlatforms);
            SyncMessage msg = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, text);
            msg.add(new InstallPlatformHyperlink(versionsToInstall));
            SyncMessages.getInstance(project).report(msg);
        }
    }
}

