/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.android;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidProjectValidationStrategy;
import com.android.tools.idea.gradle.project.sync.validation.android.BuildTools23Rc1ValidationStrategy;
import com.android.tools.idea.gradle.project.sync.validation.android.EncodingValidationStrategy;
import com.android.tools.idea.gradle.project.sync.validation.android.ExtraGeneratedFolderValidationStrategy;
import com.android.tools.idea.gradle.project.sync.validation.android.LayoutRenderingIssueValidationStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidModuleValidator {
    public abstract void validate(@NotNull Module var1, @NotNull AndroidModuleModel var2);

    public abstract void fixAndReportFoundIssues();

    @VisibleForTesting
    static class AndroidModuleValidatorImpl
    extends AndroidModuleValidator {
        @NotNull
        private final AndroidProjectValidationStrategy[] myStrategies;

        AndroidModuleValidatorImpl(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/validation/android/AndroidModuleValidator$AndroidModuleValidatorImpl", "<init>"));
            }
            this(new EncodingValidationStrategy(project), new BuildTools23Rc1ValidationStrategy(project), new LayoutRenderingIssueValidationStrategy(project), new ExtraGeneratedFolderValidationStrategy(project));
        }

        @VisibleForTesting
        AndroidModuleValidatorImpl(AndroidProjectValidationStrategy ... strategies) {
            if (strategies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategies", "com/android/tools/idea/gradle/project/sync/validation/android/AndroidModuleValidator$AndroidModuleValidatorImpl", "<init>"));
            }
            this.myStrategies = strategies;
        }

        @Override
        public void validate(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/validation/android/AndroidModuleValidator$AndroidModuleValidatorImpl", "validate"));
            }
            if (androidModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/project/sync/validation/android/AndroidModuleValidator$AndroidModuleValidatorImpl", "validate"));
            }
            for (AndroidProjectValidationStrategy strategy : this.myStrategies) {
                strategy.validate(module, androidModel);
            }
        }

        @Override
        public void fixAndReportFoundIssues() {
            for (AndroidProjectValidationStrategy strategy : this.myStrategies) {
                strategy.fixAndReportFoundIssues();
            }
        }

        @VisibleForTesting
        @NotNull
        AndroidProjectValidationStrategy[] getStrategies() {
            if (this.myStrategies == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/validation/android/AndroidModuleValidator$AndroidModuleValidatorImpl", "getStrategies"));
            }
            return this.myStrategies;
        }
    }

    public static class Factory {
        @NotNull
        public AndroidModuleValidator create(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/validation/android/AndroidModuleValidator$Factory", "create"));
            }
            AndroidModuleValidatorImpl androidModuleValidatorImpl = new AndroidModuleValidatorImpl(project);
            if (androidModuleValidatorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/validation/android/AndroidModuleValidator$Factory", "create"));
            }
            return androidModuleValidatorImpl;
        }
    }
}

