/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceUrl;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.idea.fd.BuildSelection;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GradleInstantRunContext
implements InstantRunContext {
    private final String myApplicationId;
    private final AndroidFacet myFacet;
    private final AndroidModuleModel myModel;
    private BuildSelection myBuildChoice;

    public GradleInstantRunContext(@NotNull String applicationId, @NotNull AndroidFacet appFacet) {
        if (applicationId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationId", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "<init>"));
        }
        if (appFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appFacet", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "<init>"));
        }
        this.myApplicationId = applicationId;
        this.myFacet = appFacet;
        this.myModel = AndroidModuleModel.get(appFacet);
    }

    @Override
    @Nullable
    public InstantRunBuildInfo getInstantRunBuildInfo() {
        return InstantRunGradleUtils.getBuildInfo(this.myModel);
    }

    @Override
    public void setBuildSelection(@NotNull BuildSelection buildSelection) {
        if (buildSelection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildSelection", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "setBuildSelection"));
        }
        this.myBuildChoice = buildSelection;
    }

    @Override
    @Nullable
    public BuildSelection getBuildSelection() {
        return this.myBuildChoice;
    }

    @Override
    @NotNull
    public String getApplicationId() {
        String string = this.myApplicationId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "getApplicationId"));
        }
        return string;
    }

    @Override
    @NotNull
    public GradleVersion getGradlePluginVersion() {
        GradleVersion version = this.myModel.getModelVersion();
        GradleVersion gradleVersion = version == null ? new GradleVersion(0, 0, 0) : version;
        if (gradleVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "getGradlePluginVersion"));
        }
        return gradleVersion;
    }

    @Override
    @NotNull
    public HashCode getManifestResourcesHash() {
        HashCode hashCode = GradleInstantRunContext.getManifestResourcesHash(this.myFacet);
        if (hashCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "getManifestResourcesHash"));
        }
        return hashCode;
    }

    @VisibleForTesting
    static HashCode getManifestResourcesHash(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "getManifestResourcesHash"));
        }
        Document manifest = MergedManifest.get(facet).getDocument();
        if (manifest == null || manifest.getDocumentElement() == null) {
            return HashCode.fromInt((int)0);
        }
        Hasher hasher = Hashing.goodFastHash((int)32).newHasher();
        SortedSet<ResourceUrl> appResourceReferences = GradleInstantRunContext.getAppResourceReferences(manifest.getDocumentElement());
        AppResourceRepository appResources = AppResourceRepository.getAppResources(facet, true);
        ApplicationManager.getApplication().runReadAction(() -> GradleInstantRunContext.hashResources(appResourceReferences, appResources, hasher));
        return hasher.hash();
    }

    @VisibleForTesting
    static SortedSet<ResourceUrl> getAppResourceReferences(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "getAppResourceReferences"));
        }
        TreeSet<ResourceUrl> refs = new TreeSet<ResourceUrl>(new Comparator<ResourceUrl>(){

            @Override
            public int compare(ResourceUrl o1, ResourceUrl o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        GradleInstantRunContext.addAppResourceReferences(element, refs);
        return refs;
    }

    private static void addAppResourceReferences(@NotNull Element element, @NotNull Set<ResourceUrl> refs) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "addAppResourceReferences"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "addAppResourceReferences"));
        }
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                ResourceUrl url;
                Node attribute = attributes.item(i);
                String value = attribute.getNodeValue();
                if (!value.startsWith("@") || (url = ResourceUrl.parse((String)value)) == null || url.framework) continue;
                refs.add(url);
            }
        }
        NodeList children = element.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            GradleInstantRunContext.addAppResourceReferences((Element)child, refs);
        }
    }

    private static void hashResources(@NotNull SortedSet<ResourceUrl> appResources, @NotNull AppResourceRepository resources, @NotNull Hasher hasher) {
        if (appResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appResources", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "hashResources"));
        }
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "hashResources"));
        }
        if (hasher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hasher", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "hashResources"));
        }
        for (ResourceUrl url : appResources) {
            List items = resources.getResourceItem(url.type, url.name);
            if (items == null) continue;
            for (ResourceItem item : items) {
                String text;
                ResourceValue resourceValue = item.getResourceValue(false);
                if (resourceValue == null || (text = resourceValue.getValue()) == null) continue;
                if (ResourceHelper.isFileBasedResourceType(url.type)) {
                    File f = new File(text);
                    if (!f.exists()) continue;
                    try {
                        hasher.putBytes(Files.toByteArray((File)f));
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                hasher.putString((CharSequence)text, Charsets.UTF_8);
            }
        }
    }

    @Override
    public boolean usesMultipleProcesses() {
        Document manifest = MergedManifest.get(this.myFacet).getDocument();
        if (manifest == null) {
            return false;
        }
        return GradleInstantRunContext.manifestSpecifiesMultiProcess(manifest.getDocumentElement(), InstantRunManager.ALLOWED_MULTI_PROCESSES);
    }

    @Override
    @NotNull
    public List<String> getCustomBuildArguments() {
        if (this.myModel.getProjectType() != 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "getCustomBuildArguments"));
            }
            return list;
        }
        GradleFacet facet = GradleFacet.getInstance(this.myFacet.getModule());
        if (facet == null) {
            Logger.getInstance(GradleInstantRunContext.class).warn("Unable to obtain gradle facet for module " + this.myFacet.getModule().getName());
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "getCustomBuildArguments"));
            }
            return list;
        }
        ImmutableList immutableList = ImmutableList.of((Object)AndroidGradleSettings.createProjectProperty((String)"android.injected.restrict.variant.name", (String)this.myModel.getSelectedVariant().getName()), (Object)AndroidGradleSettings.createProjectProperty((String)"android.injected.restrict.variant.project", (String)((GradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH));
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "getCustomBuildArguments"));
        }
        return immutableList;
    }

    static boolean manifestSpecifiesMultiProcess(@Nullable Element element, @NotNull Set<String> allowedProcesses) {
        if (allowedProcesses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedProcesses", "com/android/tools/idea/gradle/run/GradleInstantRunContext", "manifestSpecifiesMultiProcess"));
        }
        if (element == null) {
            return false;
        }
        NodeList children = element.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !GradleInstantRunContext.manifestSpecifiesMultiProcess((Element)child, allowedProcesses)) continue;
            return true;
        }
        String process = element.getAttributeNS("http://schemas.android.com/apk/res/android", "process");
        return !process.isEmpty() && !allowedProcesses.contains(process);
    }
}

