/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.services;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.structure.services.DeveloperServiceBuildSystemOperations;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.collect.Lists;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleOperations
implements DeveloperServiceBuildSystemOperations {
    @Override
    public boolean canHandle(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/services/GradleOperations", "canHandle"));
        }
        return Projects.isBuildWithGradle(project);
    }

    @Override
    public boolean containsAllDependencies(@NotNull Module module, @NotNull DeveloperServiceMetadata metadata) {
        DependenciesModel dependenciesModel;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/services/GradleOperations", "containsAllDependencies"));
        }
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/gradle/structure/services/GradleOperations", "containsAllDependencies"));
        }
        ArrayList moduleDependencyNames = Lists.newArrayList();
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel != null && (dependenciesModel = buildModel.dependencies()) != null) {
            for (ArtifactDependencyModel dependency : dependenciesModel.artifacts()) {
                String name = dependency.name().value();
                moduleDependencyNames.add(name);
            }
        }
        boolean allDependenciesFound = true;
        for (String serviceDependency : metadata.getDependencies()) {
            boolean thisDependencyFound = false;
            for (String moduleDependencyName : moduleDependencyNames) {
                if (!serviceDependency.contains(moduleDependencyName)) continue;
                thisDependencyFound = true;
                break;
            }
            if (thisDependencyFound) continue;
            allDependenciesFound = false;
            break;
        }
        return allDependenciesFound;
    }

    @Override
    public boolean isServiceInstalled(@NotNull Module module, @NotNull DeveloperServiceMetadata metadata) {
        DependenciesModel dependenciesModel;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/services/GradleOperations", "isServiceInstalled"));
        }
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/gradle/structure/services/GradleOperations", "isServiceInstalled"));
        }
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel != null && (dependenciesModel = buildModel.dependencies()) != null) {
            for (ArtifactDependencyModel dependency : dependenciesModel.artifacts()) {
                ArtifactDependencySpec spec = ArtifactDependencySpec.create(dependency);
                for (String dependencyValue : metadata.getDependencies()) {
                    ArtifactDependencySpec value = ArtifactDependencySpec.create(dependencyValue);
                    if (!value.equalsIgnoreVersion(spec) || VersionComparatorUtil.compare((String)spec.version, (String)value.version) < 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void removeDependencies(@NotNull Module module, @NotNull DeveloperServiceMetadata metadata) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/services/GradleOperations", "removeDependencies"));
        }
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/gradle/structure/services/GradleOperations", "removeDependencies"));
        }
        final GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel != null) {
            boolean dependenciesChanged = false;
            DependenciesModel dependenciesModel = buildModel.dependencies();
            if (dependenciesModel != null) {
                block0: for (ArtifactDependencyModel dependency : dependenciesModel.artifacts()) {
                    ArtifactDependencySpec spec = ArtifactDependencySpec.create(dependency);
                    for (String dependencyValue : metadata.getDependencies()) {
                        if (!spec.equals(ArtifactDependencySpec.create(dependencyValue))) continue;
                        dependenciesModel.remove(dependency);
                        dependenciesChanged = true;
                        continue block0;
                    }
                }
            }
            Project project = module.getProject();
            if (dependenciesChanged) {
                new WriteCommandAction.Simple(project, "Uninstall " + metadata.getName(), new PsiFile[0]){

                    public void run() {
                        buildModel.applyChanges();
                    }
                }.execute();
            }
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
        }
    }

    @Override
    public void initializeServices(@NotNull Module module, final @NotNull Runnable initializationTask) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/services/GradleOperations", "initializeServices"));
        }
        if (initializationTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializationTask", "com/android/tools/idea/gradle/structure/services/GradleOperations", "initializeServices"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        facet.addListener(new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/services/GradleOperations$2", "syncSucceeded"));
                }
                initializationTask.run();
            }
        });
    }

    @Override
    @NotNull
    public String getBuildSystemId() {
        if ("Gradle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/services/GradleOperations", "getBuildSystemId"));
        }
        return "Gradle";
    }

    @Override
    @Nullable
    public String getHighestVersion(@NotNull String groupId, @NotNull String artifactId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/android/tools/idea/gradle/structure/services/GradleOperations", "getHighestVersion"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/android/tools/idea/gradle/structure/services/GradleOperations", "getHighestVersion"));
        }
        GradleCoordinate gradleCoordinate = new GradleCoordinate(groupId, artifactId, new GradleCoordinate.RevisionComponent[]{GradleCoordinate.PLUS_REV});
        return RepositoryUrlManager.get().resolveDynamicCoordinateVersion(gradleCoordinate, null);
    }
}

