/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class BuildFileProcessor {
    @NotNull
    public static BuildFileProcessor getInstance() {
        BuildFileProcessor buildFileProcessor = (BuildFileProcessor)ServiceManager.getService(BuildFileProcessor.class);
        if (buildFileProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/BuildFileProcessor", "getInstance"));
        }
        return buildFileProcessor;
    }

    public void processRecursively(@NotNull Project project, @NotNull Processor<GradleBuildModel> processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/BuildFileProcessor", "processRecursively"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/android/tools/idea/gradle/util/BuildFileProcessor", "processRecursively"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/BuildFileProcessor", "lambda$processRecursively$1"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/android/tools/idea/gradle/util/BuildFileProcessor", "lambda$processRecursively$1"));
            }
            VirtualFile projectRootFolder = project.getBaseDir();
            if (projectRootFolder == null) {
                return;
            }
            VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)projectRootFolder, virtualFile -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/BuildFileProcessor", "lambda$null$0"));
                }
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/android/tools/idea/gradle/util/BuildFileProcessor", "lambda$null$0"));
                }
                if ("build.gradle".equals(virtualFile.getName())) {
                    GradleBuildModel buildModel = GradleBuildModel.parseBuildFile(virtualFile, project);
                    return processor.process((Object)buildModel);
                }
                return true;
            });
        });
    }
}

