/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.model.AndroidModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class Projects {
    private static final com.intellij.openapi.util.Key<LibraryDependency> MODULE_COMPILED_ARTIFACT = com.intellij.openapi.util.Key.create((String)"module.compiled.artifact");
    private static final com.intellij.openapi.util.Key<Collection<Module>> MODULES_TO_DISPOSE_POST_SYNC = com.intellij.openapi.util.Key.create((String)"project.modules.to.dispose.post.sync");
    private static final com.intellij.openapi.util.Key<Boolean> SYNC_REQUESTED_DURING_BUILD = com.intellij.openapi.util.Key.create((String)"project.sync.requested.during.build");
    private static final com.intellij.openapi.util.Key<Map<String, GradleVersion>> PLUGIN_VERSIONS_BY_MODULE = com.intellij.openapi.util.Key.create((String)"project.plugin.versions.by.module");

    private Projects() {
    }

    @NotNull
    public static File getBaseDirPath(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getBaseDirPath"));
        }
        String basePath = project.getBasePath();
        assert (basePath != null);
        File file = new File(FileUtil.toCanonicalPath((String)basePath));
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getBaseDirPath"));
        }
        return file;
    }

    public static void removeAllModuleCompiledArtifacts(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "removeAllModuleCompiledArtifacts"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            Projects.setModuleCompiledArtifact(module, null);
        }
    }

    public static void setModuleCompiledArtifact(@NotNull Module module, @Nullable LibraryDependency compiledArtifact) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "setModuleCompiledArtifact"));
        }
        module.putUserData(MODULE_COMPILED_ARTIFACT, (Object)compiledArtifact);
    }

    @Nullable
    public static LibraryDependency getModuleCompiledArtifact(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "getModuleCompiledArtifact"));
        }
        return (LibraryDependency)module.getUserData(MODULE_COMPILED_ARTIFACT);
    }

    public static void populate(@NotNull Project project, @NotNull DataNode<ProjectData> projectInfo, @Nullable PostSyncProjectSetup.Request setupRequest, boolean selectModulesToImport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "populate"));
        }
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/util/Projects", "populate"));
        }
        Collection<DataNode<ModuleData>> modulesToImport = Projects.getModulesToImport(project, projectInfo, selectModulesToImport);
        Projects.populate(project, projectInfo, modulesToImport, setupRequest);
    }

    @NotNull
    private static Collection<DataNode<ModuleData>> getModulesToImport(@NotNull Project project, @NotNull DataNode<ProjectData> projectInfo, boolean selectModulesToImport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getModulesToImport"));
        }
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/util/Projects", "getModulesToImport"));
        }
        Collection modules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        ProjectSubset subview = ProjectSubset.getInstance(project);
        if (!ApplicationManager.getApplication().isUnitTestMode() && ProjectSubset.getInstance(project).isFeatureEnabled() && modules.size() > 1) {
            if (selectModulesToImport) {
                Collection<DataNode<ModuleData>> selection = subview.showModuleSelectionDialog(modules);
                if (selection != null) {
                    Collection<DataNode<ModuleData>> collection = selection;
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToImport"));
                    }
                    return collection;
                }
            } else {
                int moduleCount;
                Object[] persistedModuleNames = subview.getSelection();
                if (persistedModuleNames != null && (moduleCount = persistedModuleNames.length) > 0) {
                    ArrayList moduleNames = Lists.newArrayList((Object[])persistedModuleNames);
                    ArrayList selectedModules = Lists.newArrayListWithExpectedSize((int)moduleCount);
                    for (DataNode module : modules) {
                        String name = ((ModuleData)module.getData()).getExternalName();
                        if (!moduleNames.contains(name)) continue;
                        selectedModules.add(module);
                    }
                    ArrayList arrayList = selectedModules;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToImport"));
                    }
                    return arrayList;
                }
            }
        }
        subview.clearSelection();
        Collection collection = modules;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToImport"));
        }
        return collection;
    }

    public static void populate(@NotNull Project project, @NotNull DataNode<ProjectData> projectInfo, @NotNull Collection<DataNode<ModuleData>> modulesToImport, @Nullable PostSyncProjectSetup.Request setupRequest) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "populate"));
        }
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/util/Projects", "populate"));
        }
        if (modulesToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesToImport", "com/android/tools/idea/gradle/util/Projects", "populate"));
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "lambda$populate$2"));
            }
            if (projectInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/util/Projects", "lambda$populate$2"));
            }
            if (modulesToImport == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesToImport", "com/android/tools/idea/gradle/util/Projects", "lambda$populate$2"));
            }
            SyncMessages.getInstance(project).removeProjectMessages();
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "lambda$null$1"));
                }
                if (projectInfo == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/util/Projects", "lambda$null$1"));
                }
                if (modulesToImport == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesToImport", "com/android/tools/idea/gradle/util/Projects", "lambda$null$1"));
                }
                if (!project.isDisposed()) {
                    ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(() -> {
                        if (projectInfo == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/util/Projects", "lambda$null$0"));
                        }
                        if (modulesToImport == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesToImport", "com/android/tools/idea/gradle/util/Projects", "lambda$null$0"));
                        }
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "lambda$null$0"));
                        }
                        Projects.disableExcludedModules(projectInfo, modulesToImport);
                        Projects.doSelectiveImport(modulesToImport, project);
                    });
                }
            });
            if (setupRequest != null) {
                PostSyncProjectSetup.getInstance(project).setUpProject(setupRequest, null);
            }
        });
    }

    private static void disableExcludedModules(@NotNull DataNode<ProjectData> projectInfo, @NotNull Collection<DataNode<ModuleData>> selectedModules) {
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/util/Projects", "disableExcludedModules"));
        }
        if (selectedModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedModules", "com/android/tools/idea/gradle/util/Projects", "disableExcludedModules"));
        }
        Collection allModules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        if (selectedModules.size() != allModules.size()) {
            HashSet moduleToIgnore = Sets.newHashSet((Iterable)allModules);
            moduleToIgnore.removeAll(selectedModules);
            for (DataNode moduleNode : moduleToIgnore) {
                ExternalSystemApiUtil.visit((DataNode)moduleNode, node -> node.setIgnored(true));
            }
        }
    }

    private static void doSelectiveImport(@NotNull Collection<DataNode<ModuleData>> enabledModules, @NotNull Project project) {
        DataNode projectNode;
        if (enabledModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enabledModules", "com/android/tools/idea/gradle/util/Projects", "doSelectiveImport"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "doSelectiveImport"));
        }
        ProjectDataManager dataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
        DataNode dataNode = projectNode = enabledModules.isEmpty() ? null : ExternalSystemApiUtil.findParent(enabledModules.iterator().next(), (Key)ProjectKeys.PROJECT);
        if (projectNode != null) {
            Collection allModules = ExternalSystemApiUtil.findAll((DataNode)projectNode, (Key)ProjectKeys.MODULE);
            if (enabledModules.size() != allModules.size()) {
                THashSet moduleToIgnore = ContainerUtil.newIdentityTroveSet((Collection)allModules);
                moduleToIgnore.removeAll(enabledModules);
                for (DataNode moduleNode : moduleToIgnore) {
                    ExternalSystemApiUtil.visit((DataNode)moduleNode, node -> node.setIgnored(true));
                }
            }
            dataManager.importData(projectNode, project, true);
        } else {
            dataManager.importData(enabledModules, project, true);
        }
    }

    public static void executeProjectChanges(@NotNull Project project, @NotNull Runnable changes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "executeProjectChanges"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/android/tools/idea/gradle/util/Projects", "executeProjectChanges"));
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            if (!project.isDisposed()) {
                changes.run();
            }
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "lambda$executeProjectChanges$6"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/android/tools/idea/gradle/util/Projects", "lambda$executeProjectChanges$6"));
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "lambda$null$5"));
                }
                if (changes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/android/tools/idea/gradle/util/Projects", "lambda$null$5"));
                }
                if (!project.isDisposed()) {
                    ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(changes);
                }
            });
        }, ModalityState.defaultModalityState());
    }

    public static boolean requiredAndroidModelMissing(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "requiredAndroidModelMissing"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || !facet.requiresAndroidModel() || facet.getAndroidModel() != null) continue;
            return true;
        }
        return false;
    }

    public static void open(@NotNull Project project) {
        boolean fullScreen;
        IdeFocusManager instance;
        IdeFrame lastFocusedFrame;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "open"));
        }
        ProjectUtil.updateLastProjectLocation((String)project.getBasePath());
        if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (lastFocusedFrame = (instance = IdeFocusManager.findInstance()).getLastFocusedFrame()) instanceof IdeFrameEx && (fullScreen = ((IdeFrameEx)lastFocusedFrame).isInFullScreen())) {
            project.putUserData(IdeFrameImpl.SHOULD_OPEN_IN_FULL_SCREEN, (Object)Boolean.TRUE);
        }
        ProjectManagerEx.getInstanceEx().openProject(project);
    }

    public static boolean isDirectGradleInvocationEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isDirectGradleInvocationEnabled"));
        }
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
        return buildConfiguration.USE_EXPERIMENTAL_FASTER_BUILD;
    }

    public static boolean isOfflineBuildModeEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isOfflineBuildModeEnabled"));
        }
        return GradleSettings.getInstance((Project)project).isOfflineWork();
    }

    @Nullable
    public static AndroidModel getAndroidModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "getAndroidModel"));
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        return androidFacet != null ? androidFacet.getAndroidModel() : null;
    }

    public static boolean isLegacyIdeaAndroidProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isLegacyIdeaAndroidProject"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            if (!Projects.isLegacyIdeaAndroidModule(module)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLegacyIdeaAndroidModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "isLegacyIdeaAndroidModule"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null && !facet.requiresAndroidModel();
    }

    @NotNull
    public static Module[] getModulesToBuildFromSelection(@NotNull Project project, @Nullable DataContext dataContext) {
        Module[] modules;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
        }
        if (dataContext == null) {
            ProjectView projectView = ProjectView.getInstance((Project)project);
            AbstractProjectViewPane pane = projectView.getCurrentProjectViewPane();
            if (pane != null) {
                JComponent treeComponent = pane.getComponentToFocus();
                dataContext = DataManager.getInstance().getDataContext((Component)treeComponent);
            } else {
                if (Module.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
                }
                return Module.EMPTY_ARRAY;
            }
        }
        if ((modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext)) != null) {
            if (modules.length == 1 && Projects.isProjectModule(modules[0])) {
                Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
                if (moduleArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
                }
                return moduleArray;
            }
            if (modules == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
            }
            return modules;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module != null) {
            Module[] moduleArray;
            if (Projects.isProjectModule(module)) {
                moduleArray = ModuleManager.getInstance((Project)project).getModules();
            } else {
                Module[] moduleArray2 = new Module[1];
                moduleArray = moduleArray2;
                moduleArray2[0] = module;
            }
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
        }
        return Module.EMPTY_ARRAY;
    }

    public static boolean isProjectModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "isProjectModule"));
        }
        File moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
        File moduleRootDirPath = moduleFilePath.getParentFile();
        if (moduleRootDirPath == null) {
            return false;
        }
        String basePath = module.getProject().getBasePath();
        return basePath != null && FileUtil.filesEqual((File)moduleRootDirPath, (File)new File(basePath)) && !Projects.isBuildWithGradle(module);
    }

    @Deprecated
    public static boolean isBuildWithGradle(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isBuildWithGradle"));
        }
        return GradleProjectInfo.getInstance(project).isBuildWithGradle();
    }

    public static boolean isBuildWithGradle(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "isBuildWithGradle"));
        }
        return GradleFacet.getInstance(module) != null;
    }

    public static boolean isGradleProjectModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "isGradleProjectModule"));
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return false;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet != null && androidFacet.requiresAndroidModel() && Projects.isBuildWithGradle(module)) {
            File moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
            File moduleRootDirPath = moduleFilePath.getParentFile();
            return FileUtil.pathsEqual((String)moduleRootDirPath.getPath(), (String)module.getProject().getBasePath());
        }
        return !Projects.isBuildWithGradle(module);
    }

    @Nullable
    public static Collection<Module> getModulesToDisposePostSync(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getModulesToDisposePostSync"));
        }
        return (Collection)project.getUserData(MODULES_TO_DISPOSE_POST_SYNC);
    }

    public static void setModulesToDisposePostSync(@NotNull Project project, @Nullable Collection<Module> modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "setModulesToDisposePostSync"));
        }
        project.putUserData(MODULES_TO_DISPOSE_POST_SYNC, modules);
    }

    public static boolean canImportAsGradleProject(@NotNull VirtualFile importSource) {
        if (importSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importSource", "com/android/tools/idea/gradle/util/Projects", "canImportAsGradleProject"));
        }
        VirtualFile target = ProjectImportUtil.findImportTarget(importSource);
        return target != null && "gradle".equals(target.getExtension());
    }

    public static void setSyncRequestedDuringBuild(@NotNull Project project, @Nullable Boolean value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "setSyncRequestedDuringBuild"));
        }
        project.putUserData(SYNC_REQUESTED_DURING_BUILD, (Object)value);
    }

    public static boolean isSyncRequestedDuringBuild(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isSyncRequestedDuringBuild"));
        }
        return Projects.getBoolean(project, SYNC_REQUESTED_DURING_BUILD);
    }

    private static boolean getBoolean(@NotNull Project project, @NotNull com.intellij.openapi.util.Key<Boolean> key) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getBoolean"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/gradle/util/Projects", "getBoolean"));
        }
        Boolean val = (Boolean)project.getUserData(key);
        return val != null && val != false;
    }

    public static void storePluginVersionsPerModule(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "storePluginVersionsPerModule"));
        }
        HashMap pluginVersionsPerModule = Maps.newHashMap();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            GradleVersion modelVersion;
            GradleFacet facet;
            AndroidModuleModel model = AndroidModuleModel.get(module);
            if (model == null || (facet = GradleFacet.getInstance(module)) == null || (modelVersion = model.getModelVersion()) == null) continue;
            pluginVersionsPerModule.put(((GradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH, modelVersion);
        }
        project.putUserData(PLUGIN_VERSIONS_BY_MODULE, (Object)pluginVersionsPerModule);
    }

    @Nullable
    public static Map<String, GradleVersion> getPluginVersionsPerModule(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getPluginVersionsPerModule"));
        }
        return (Map)project.getUserData(PLUGIN_VERSIONS_BY_MODULE);
    }
}

