/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.NdkModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildVariantUpdater {
    private static final Logger LOG = Logger.getInstance(BuildVariantUpdater.class);

    BuildVariantUpdater() {
    }

    boolean updateSelectedVariant(@NotNull Project project, @NotNull String moduleName, @NotNull String buildVariantName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (buildVariantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildVariantName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        ArrayList affectedAndroidFacets = new ArrayList();
        ArrayList affectedNdkFacets = new ArrayList();
        Projects.executeProjectChanges(project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "lambda$updateSelectedVariant$0"));
            }
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "lambda$updateSelectedVariant$0"));
            }
            if (buildVariantName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildVariantName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "lambda$updateSelectedVariant$0"));
            }
            Module updatedModule = this.doUpdate(project, moduleName, buildVariantName, affectedAndroidFacets, affectedNdkFacets);
            if (updatedModule != null) {
                ConflictSet conflicts = ConflictSet.findConflicts(project);
                conflicts.showSelectionConflicts();
            }
            PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
            setupRequest.setGenerateSourcesAfterSync(false).setCleanProjectAfterSync(false);
            PostSyncProjectSetup.getInstance(project).setUpProject(setupRequest, null);
            BuildVariantUpdater.generateSourcesIfNeeded(affectedAndroidFacets);
        });
        return !affectedAndroidFacets.isEmpty() || !affectedNdkFacets.isEmpty();
    }

    @Nullable
    private Module doUpdate(@NotNull Project project, @NotNull String moduleName, @NotNull String variant, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNativeAndroidFacets) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "doUpdate"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "doUpdate"));
        }
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "doUpdate"));
        }
        if (affectedAndroidFacets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedAndroidFacets", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "doUpdate"));
        }
        if (affectedNativeAndroidFacets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedNativeAndroidFacets", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "doUpdate"));
        }
        Module moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName);
        if (moduleToUpdate == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module '%1$s'.", moduleName));
            return null;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(moduleToUpdate);
        NdkFacet ndkFacet = NdkFacet.getInstance(moduleToUpdate);
        if (androidFacet == null && ndkFacet == null) {
            String msg = String.format("Cannot find 'Android' or 'Native-Android-Gradle' facets in module '%1$s'.", moduleToUpdate.getName());
            BuildVariantUpdater.logAndShowUpdateFailure(variant, msg);
        }
        if (ndkFacet != null) {
            NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNativeAndroidModel(ndkFacet, variant);
            if (ndkModuleModel == null || !BuildVariantUpdater.updateSelectedVariant(ndkFacet, ndkModuleModel, variant)) {
                return null;
            }
            affectedNativeAndroidFacets.add(ndkFacet);
        }
        if (androidFacet != null) {
            AndroidModuleModel androidModel = BuildVariantUpdater.getAndroidModel(androidFacet, variant);
            if (androidModel == null || !this.updateSelectedVariant(androidFacet, androidModel, variant, affectedAndroidFacets)) {
                return null;
            }
            affectedAndroidFacets.add(androidFacet);
        }
        return moduleToUpdate;
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String moduleName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "findModule"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "findModule"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.findModuleByName(moduleName);
    }

    private boolean updateSelectedVariant(@NotNull AndroidFacet androidFacet, @NotNull AndroidModuleModel androidModel, @NotNull String variantToSelect, @NotNull List<AndroidFacet> affectedFacets) {
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (variantToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantToSelect", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (affectedFacets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFacets", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        Variant selectedVariant = androidModel.getSelectedVariant();
        if (variantToSelect.equals(selectedVariant.getName())) {
            return false;
        }
        androidModel.setSelectedVariantName(variantToSelect);
        androidModel.syncSelectedVariantAndTestArtifact(androidFacet);
        Module module = BuildVariantUpdater.setUpModule(androidFacet.getModule(), androidModel);
        for (AndroidLibrary library : androidModel.getSelectedMainCompileDependencies().getLibraries()) {
            String projectVariant;
            String gradlePath = library.getProject();
            if (StringUtil.isEmpty((String)gradlePath) || !StringUtil.isNotEmpty((String)(projectVariant = library.getProjectVariant()))) continue;
            this.ensureVariantIsSelected(module.getProject(), gradlePath, projectVariant, affectedFacets);
        }
        return true;
    }

    private static boolean updateSelectedVariant(@NotNull NdkFacet ndkFacet, @NotNull NdkModuleModel ndkModuleModel, @NotNull String variantToSelect) {
        if (ndkFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ndkFacet", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (ndkModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ndkModuleModel", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (variantToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantToSelect", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        NdkModuleModel.NdkVariant selectedVariant = ndkModuleModel.getSelectedVariant();
        if (variantToSelect.equals(selectedVariant.getName())) {
            return false;
        }
        ndkModuleModel.setSelectedVariantName(variantToSelect);
        ((NdkFacetConfiguration)ndkFacet.getConfiguration()).SELECTED_BUILD_VARIANT = ndkModuleModel.getSelectedVariant().getName();
        BuildVariantUpdater.setUpModule(ndkFacet.getModule(), ndkModuleModel);
        return true;
    }

    private static void generateSourcesIfNeeded(@NotNull List<AndroidFacet> affectedFacets) {
        if (affectedFacets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFacets", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "generateSourcesIfNeeded"));
        }
        if (!affectedFacets.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
            Project project = affectedFacets.get(0).getModule().getProject();
            GradleProjectBuilder.getInstance(project).generateSourcesOnly(false);
        }
    }

    @NotNull
    private static Module setUpModule(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "setUpModule"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "setUpModule"));
        }
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(module.getProject());
        try {
            for (AndroidModuleSetupStep setupStep : AndroidModuleSetupStep.getExtensions()) {
                if (!setupStep.invokeOnBuildVariantChange()) continue;
                setupStep.setUpModule(module, (IdeModifiableModelsProvider)modelsProvider, androidModel, null, null);
            }
            modelsProvider.commit();
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "setUpModule"));
        }
        return module2;
    }

    @NotNull
    private static Module setUpModule(@NotNull Module module, @NotNull NdkModuleModel ndkModuleModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "setUpModule"));
        }
        if (ndkModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ndkModuleModel", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "setUpModule"));
        }
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(module.getProject());
        try {
            for (NdkModuleSetupStep setupStep : NdkModuleSetupStep.getExtensions()) {
                if (!setupStep.invokeOnBuildVariantChange()) continue;
                setupStep.setUpModule(module, (IdeModifiableModelsProvider)modelsProvider, ndkModuleModel, null, null);
            }
            modelsProvider.commit();
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "setUpModule"));
        }
        return module2;
    }

    private void ensureVariantIsSelected(@NotNull Project project, @NotNull String moduleGradlePath, @NotNull String variant, @NotNull List<AndroidFacet> affectedFacets) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "ensureVariantIsSelected"));
        }
        if (moduleGradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleGradlePath", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "ensureVariantIsSelected"));
        }
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "ensureVariantIsSelected"));
        }
        if (affectedFacets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFacets", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "ensureVariantIsSelected"));
        }
        Module module = GradleUtil.findModuleByGradlePath(project, moduleGradlePath);
        if (module == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module with Gradle path '%1$s'.", moduleGradlePath));
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find 'Android' facet in module '%1$s'.", module.getName()));
            return;
        }
        AndroidModuleModel androidModel = BuildVariantUpdater.getAndroidModel(facet, variant);
        if (androidModel == null) {
            return;
        }
        if (!this.updateSelectedVariant(facet, androidModel, variant, affectedFacets)) {
            return;
        }
        affectedFacets.add(facet);
    }

    @Nullable
    private static AndroidModuleModel getAndroidModel(@NotNull AndroidFacet facet, @NotNull String variantToSelect) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getAndroidModel"));
        }
        if (variantToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantToSelect", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getAndroidModel"));
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
        if (androidModel == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find AndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return androidModel;
    }

    @Nullable
    private static NdkModuleModel getNativeAndroidModel(@NotNull NdkFacet facet, @NotNull String variantToSelect) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getNativeAndroidModel"));
        }
        if (variantToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantToSelect", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getNativeAndroidModel"));
        }
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(facet);
        if (ndkModuleModel == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find NativeAndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return ndkModuleModel;
    }

    private static void logAndShowUpdateFailure(@NotNull String buildVariantName, @NotNull String reason) {
        if (buildVariantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildVariantName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "logAndShowUpdateFailure"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "logAndShowUpdateFailure"));
        }
        String prefix = String.format("Unable to select build variant '%1$s':\n", buildVariantName);
        String msg = prefix + reason;
        LOG.error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }
}

