/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding;

import android.databinding.tool.reflection.Callable;
import android.databinding.tool.reflection.ModelMethod;
import com.android.ide.common.res2.DataBindingResourceType;
import com.android.tools.idea.lang.databinding.DbFileType;
import com.android.tools.idea.lang.databinding.DefinitionReference;
import com.android.tools.idea.lang.databinding.model.PsiModelClass;
import com.android.tools.idea.lang.databinding.model.PsiModelMethod;
import com.android.tools.idea.lang.databinding.psi.PsiDbDotExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbExpressionList;
import com.android.tools.idea.lang.databinding.psi.PsiDbFieldName;
import com.android.tools.idea.lang.databinding.psi.PsiDbIdExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbMethodExpr;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.converters.DataBindingConverter;
import org.jetbrains.android.dom.layout.AndroidLayoutUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingXmlReferenceContributor
extends PsiReferenceContributor {
    @Nullable
    public static DataBindingInfo getDataBindingInfo(PsiElement element) {
        AndroidFacet facet;
        DataBindingInfo dataBindingInfo = null;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && facet.isDataBindingEnabled()) {
            LocalResourceRepository moduleResources = facet.getModuleResources(true);
            PsiFile topLevelFile = InjectedLanguageUtil.getTopLevelFile((PsiElement)element);
            if (topLevelFile != null) {
                String name = topLevelFile.getName();
                name = name.substring(0, name.lastIndexOf(46));
                dataBindingInfo = moduleResources.getDataBindingInfoForLayout(name);
            }
        }
        return dataBindingInfo;
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PsiDbIdExpr.class), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                PsiClass langClass;
                XmlTag xmlTag;
                Object facet;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$1", "getReferencesByElement"));
                }
                PsiDbIdExpr id = (PsiDbIdExpr)element;
                String text = element.getText();
                if (text == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$1", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                DataBindingInfo dataBindingInfo = null;
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (module != null && (facet = AndroidFacet.getInstance(module)) != null && ((AndroidFacet)((Object)facet)).isDataBindingEnabled()) {
                    LocalResourceRepository moduleResources = ((AndroidFacet)((Object)facet)).getModuleResources(true);
                    PsiFile topLevelFile = InjectedLanguageUtil.getTopLevelFile((PsiElement)element);
                    if (topLevelFile != null) {
                        PsiElement fileContext;
                        if (topLevelFile.getFileType() == DbFileType.INSTANCE && (fileContext = topLevelFile.getContext()) != null) {
                            topLevelFile = fileContext.getContainingFile();
                        }
                        String name = topLevelFile.getName();
                        name = name.substring(0, name.lastIndexOf(46));
                        dataBindingInfo = moduleResources.getDataBindingInfoForLayout(name);
                    }
                }
                if (dataBindingInfo == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$1", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                for (PsiDataBindingResourceItem variable : dataBindingInfo.getItems(DataBindingResourceType.VARIABLE)) {
                    if (!text.equals(variable.getName())) continue;
                    xmlTag = variable.getXmlTag();
                    PsiReference[] psiReferenceArray = DataBindingXmlReferenceContributor.toArray(new PsiReference[]{new VariableDefinitionReference(id, xmlTag, variable, dataBindingInfo, module)});
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                for (PsiDataBindingResourceItem anImport : dataBindingInfo.getItems(DataBindingResourceType.IMPORT)) {
                    if (!text.equals(AndroidLayoutUtil.getAlias(anImport))) continue;
                    xmlTag = anImport.getXmlTag();
                    PsiReference[] psiReferenceArray = DataBindingXmlReferenceContributor.toArray(new PsiReference[]{new ImportDefinitionReference(id, xmlTag, anImport, module)});
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)id.getProject());
                if (text.indexOf(46) == -1 && (langClass = javaPsiFacade.findClass("java.lang." + text, GlobalSearchScope.moduleWithLibrariesScope((Module)module))) != null) {
                    PsiReference[] psiReferenceArray = DataBindingXmlReferenceContributor.toArray(new PsiReference[]{new ClassDefinitionReference((PsiElement)id, langClass)});
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                PsiPackage aPackage = javaPsiFacade.findPackage(text);
                if (aPackage != null) {
                    PsiReference[] psiReferenceArray = DataBindingXmlReferenceContributor.toArray(new PsiReference[]{new PackageReference(id, aPackage)});
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$1", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PsiDbDotExpr.class), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                Module module;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$2", "getReferencesByElement"));
                }
                PsiDbDotExpr dotExpr = (PsiDbDotExpr)element;
                ResolvesToModelClass ref = DataBindingXmlReferenceContributor.resolveClassReference(dotExpr.getExpr());
                PsiModelClass psiModelClass = DataBindingXmlReferenceContributor.resolveClassType(ref);
                if (psiModelClass == null) {
                    PsiReference[] references = dotExpr.getExpr().getReferences();
                    if (references.length > 0) {
                        String fieldText = dotExpr.getFieldName().getText();
                        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                        if (module2 == null || StringUtil.isEmpty((String)fieldText)) {
                            if (PsiReference.EMPTY_ARRAY == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$2", "getReferencesByElement"));
                            }
                            return PsiReference.EMPTY_ARRAY;
                        }
                        GlobalSearchScope scope = module2.getModuleWithDependenciesAndLibrariesScope(false);
                        for (PsiReference reference : references) {
                            PsiPackage aPackage;
                            if (!(reference instanceof PackageReference) || (aPackage = ((PackageReference)reference).resolve()) == null) continue;
                            for (PsiPackage subPackage : aPackage.getSubPackages(scope)) {
                                String name = subPackage.getName();
                                if (!name.endsWith(fieldText) || name.length() != fieldText.length() && name.charAt(name.length() - fieldText.length() - 1) != '.') continue;
                                PsiReference[] psiReferenceArray = DataBindingXmlReferenceContributor.toArray(new PsiReference[]{new PackageReference(element, subPackage)});
                                if (psiReferenceArray == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$2", "getReferencesByElement"));
                                }
                                return psiReferenceArray;
                            }
                            PsiClass[] classes = aPackage.findClassByShortName(fieldText, scope);
                            if (classes.length <= 0) continue;
                            PsiReference[] refs = new PsiReference[classes.length];
                            for (int i = 0; i < classes.length; ++i) {
                                refs[i] = new ClassDefinitionReference(element, classes[i]);
                            }
                            if (refs == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$2", "getReferencesByElement"));
                            }
                            return refs;
                        }
                    }
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$2", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiDbFieldName fieldName = dotExpr.getFieldName();
                String fieldText = fieldName.getText();
                if (StringUtil.isEmpty((String)fieldText)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$2", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                Callable getterOrField = psiModelClass.findGetterOrField(fieldText, ref.isStatic());
                PsiClass psiClass = psiModelClass.getPsiClass();
                if (psiClass == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$2", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                if (getterOrField != null) {
                    PsiField fieldsByName;
                    if (getterOrField.type.equals((Object)Callable.Type.METHOD)) {
                        PsiMethod[] methodsByName = psiClass.findMethodsByName(getterOrField.name, true);
                        if (methodsByName.length > 0) {
                            PsiReference[] psiReferenceArray = DataBindingXmlReferenceContributor.toArray(new PsiReference[]{new PsiMethodReference(dotExpr, methodsByName[0])});
                            if (psiReferenceArray == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$2", "getReferencesByElement"));
                            }
                            return psiReferenceArray;
                        }
                    } else if (getterOrField.type.equals((Object)Callable.Type.FIELD) && (fieldsByName = psiClass.findFieldByName(getterOrField.name, true)) != null) {
                        PsiReference[] psiReferenceArray = DataBindingXmlReferenceContributor.toArray(new PsiReference[]{new PsiFieldReference(dotExpr, fieldsByName)});
                        if (psiReferenceArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$2", "getReferencesByElement"));
                        }
                        return psiReferenceArray;
                    }
                }
                if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null) {
                    String innerName = psiClass.getQualifiedName() + '.' + fieldText;
                    PsiClass clazz = JavaPsiFacade.getInstance((Project)element.getProject()).findClass(innerName, module.getModuleWithDependenciesAndLibrariesScope(false));
                    if (clazz != null) {
                        PsiReference[] psiReferenceArray = DataBindingXmlReferenceContributor.toArray(new PsiReference[]{new ClassDefinitionReference(element, clazz)});
                        if (psiReferenceArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$2", "getReferencesByElement"));
                        }
                        return psiReferenceArray;
                    }
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$2", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PsiDbMethodExpr.class), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                ModelMethod method;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$3", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$3", "getReferencesByElement"));
                }
                PsiDbMethodExpr methodExpr = (PsiDbMethodExpr)element;
                PsiModelClass psiModelClass = DataBindingXmlReferenceContributor.resolveClassType(DataBindingXmlReferenceContributor.resolveClassReference(methodExpr.getExpr()));
                if (psiModelClass == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$3", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                ArrayList args = Lists.newArrayList();
                boolean hasInvalidArg = false;
                PsiDbExpressionList expressionList = methodExpr.getExpressionList();
                if (expressionList != null) {
                    for (PsiDbExpr expr : expressionList.getExprList()) {
                        PsiModelClass refClass = DataBindingXmlReferenceContributor.resolveClassType(DataBindingXmlReferenceContributor.resolveClassReference(expr));
                        if (refClass == null) {
                            hasInvalidArg = true;
                            break;
                        }
                        args.add(refClass);
                    }
                }
                if (!hasInvalidArg && (method = psiModelClass.getMethod(methodExpr.getMethodName().getText(), args, false, false)) instanceof PsiModelMethod) {
                    PsiReference[] psiReferenceArray = DataBindingXmlReferenceContributor.toArray(new PsiReference[]{new PsiMethodReference(methodExpr, ((PsiModelMethod)method).getPsiMethod())});
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$3", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                List methods = psiModelClass.findMethods(methodExpr.getMethodName().getText(), false);
                if (methods == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$3", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                ArrayList selected = Lists.newArrayList();
                for (ModelMethod modelMethod : methods) {
                    if (!(modelMethod instanceof PsiModelMethod)) continue;
                    selected.add(new PsiMethodReference(methodExpr, ((PsiModelMethod)modelMethod).getPsiMethod()));
                }
                PsiReference[] psiReferenceArray = selected.toArray(new PsiReference[selected.size()]);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$3", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    @Nullable
    private static PsiModelClass resolveClassType(@Nullable ResolvesToModelClass ref) {
        return ref == null ? null : ref.getResolvedType();
    }

    @Nullable
    private static ResolvesToModelClass resolveClassReference(@NotNull PsiDbExpr expr) {
        PsiReference[] references;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor", "resolveClassReference"));
        }
        for (PsiReference ref : references = expr.getReferences()) {
            if (!(ref instanceof ResolvesToModelClass)) continue;
            return (ResolvesToModelClass)ref;
        }
        return null;
    }

    private static PsiReference[] toArray(PsiReference ... ref) {
        return ref;
    }

    private static class PackageReference
    implements PsiReference {
        private final PsiElement myElement;
        private final PsiPackage myTarget;
        private final TextRange myTextRange;

        public PackageReference(@NotNull PsiElement element, @NotNull PsiPackage target) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$PackageReference", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$PackageReference", "<init>"));
            }
            this.myElement = element;
            this.myTarget = target;
            this.myTextRange = this.myElement.getTextRange().shiftRight(-this.myElement.getStartOffsetInParent());
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        public TextRange getRangeInElement() {
            return this.myTextRange;
        }

        @Nullable
        public PsiPackage resolve() {
            return this.myTarget;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myElement.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$PackageReference", "getCanonicalText"));
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$PackageReference", "bindToElement"));
            }
            return null;
        }

        public boolean isReferenceTo(PsiElement element) {
            return this.myElement.getManager().areElementsEquivalent((PsiElement)this.resolve(), element);
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$PackageReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return false;
        }
    }

    private static class ClassDefinitionReference
    extends DefinitionReference {
        public ClassDefinitionReference(@NotNull PsiElement element, @NotNull PsiClass resolveTo) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$ClassDefinitionReference", "<init>"));
            }
            if (resolveTo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveTo", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$ClassDefinitionReference", "<init>"));
            }
            super(element, (PsiElement)resolveTo);
        }

        @Override
        @NotNull
        public PsiModelClass getResolvedType() {
            PsiModelClass psiModelClass = new PsiModelClass((PsiType)PsiTypesUtil.getClassType((PsiClass)((PsiClass)this.myTarget)));
            if (psiModelClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$ClassDefinitionReference", "getResolvedType"));
            }
            return psiModelClass;
        }

        @Override
        public boolean isStatic() {
            return true;
        }
    }

    private static class ImportDefinitionReference
    extends DefinitionReference {
        private PsiModelClass myModelClass;

        public ImportDefinitionReference(@NotNull PsiElement element, @NotNull XmlTag resolveTo, @NotNull PsiDataBindingResourceItem variable, @NotNull Module module) {
            PsiClass psiType;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$ImportDefinitionReference", "<init>"));
            }
            if (resolveTo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveTo", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$ImportDefinitionReference", "<init>"));
            }
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$ImportDefinitionReference", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$ImportDefinitionReference", "<init>"));
            }
            super(element, (PsiElement)resolveTo);
            String type = variable.getTypeDeclaration();
            if (type != null && (psiType = JavaPsiFacade.getInstance((Project)element.getProject()).findClass(type, module.getModuleWithDependenciesAndLibrariesScope(false))) != null) {
                this.myModelClass = new PsiModelClass((PsiType)PsiTypesUtil.getClassType((PsiClass)psiType));
            }
        }

        @Override
        public PsiModelClass getResolvedType() {
            return this.myModelClass;
        }

        @Override
        public boolean isStatic() {
            return true;
        }
    }

    private static class VariableDefinitionReference
    extends DefinitionReference {
        private PsiModelClass myModelClass;

        public VariableDefinitionReference(@NotNull PsiElement element, @NotNull XmlTag resolveTo, @NotNull PsiDataBindingResourceItem variable, @NotNull DataBindingInfo dataBindingInfo, @NotNull Module module) {
            PsiClass psiType;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$VariableDefinitionReference", "<init>"));
            }
            if (resolveTo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveTo", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$VariableDefinitionReference", "<init>"));
            }
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$VariableDefinitionReference", "<init>"));
            }
            if (dataBindingInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataBindingInfo", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$VariableDefinitionReference", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$VariableDefinitionReference", "<init>"));
            }
            super(element, (PsiElement)resolveTo);
            String type = DataBindingConverter.getQualifiedType(variable.getTypeDeclaration(), dataBindingInfo);
            if (type != null && (psiType = JavaPsiFacade.getInstance((Project)element.getProject()).findClass(type, module.getModuleWithDependenciesAndLibrariesScope(false))) != null) {
                this.myModelClass = new PsiModelClass((PsiType)PsiTypesUtil.getClassType((PsiClass)psiType));
            }
        }

        @Override
        @Nullable
        public PsiModelClass getResolvedType() {
            return this.myModelClass;
        }

        @Override
        public boolean isStatic() {
            return false;
        }
    }

    private static class PsiMethodReference
    extends DefinitionReference {
        public PsiMethodReference(@NotNull PsiDbMethodExpr expr, @NotNull PsiMethod method) {
            if (expr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$PsiMethodReference", "<init>"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$PsiMethodReference", "<init>"));
            }
            super(expr, (PsiElement)method, expr.getMethodName().getTextRange().shiftRight(-expr.getStartOffsetInParent()));
        }

        public PsiMethodReference(@NotNull PsiDbDotExpr expr, @NotNull PsiMethod method) {
            if (expr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$PsiMethodReference", "<init>"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$PsiMethodReference", "<init>"));
            }
            super(expr, (PsiElement)method, expr.getFieldName().getTextRange().shiftRight(-expr.getStartOffsetInParent()));
        }

        @Override
        @Nullable
        public PsiModelClass getResolvedType() {
            PsiType returnType = ((PsiMethod)this.myTarget).getReturnType();
            return returnType != null ? new PsiModelClass(returnType) : null;
        }

        @Override
        public boolean isStatic() {
            return false;
        }
    }

    private static class PsiFieldReference
    extends DefinitionReference {
        public PsiFieldReference(@NotNull PsiDbDotExpr dotExpr, @NotNull PsiField field) {
            if (dotExpr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dotExpr", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$PsiFieldReference", "<init>"));
            }
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$PsiFieldReference", "<init>"));
            }
            super(dotExpr, (PsiElement)field, dotExpr.getFieldName().getTextRange().shiftRight(-dotExpr.getStartOffsetInParent()));
        }

        @Override
        @NotNull
        public PsiModelClass getResolvedType() {
            PsiModelClass psiModelClass = new PsiModelClass(((PsiField)this.myTarget).getType());
            if (psiModelClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DataBindingXmlReferenceContributor$PsiFieldReference", "getResolvedType"));
            }
            return psiModelClass;
        }

        @Override
        public boolean isStatic() {
            PsiModifierList modifierList = ((PsiField)this.myTarget).getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("static");
        }
    }

    public static interface ResolvesToModelClass {
        @Nullable
        public PsiModelClass getResolvedType();

        public boolean isStatic();
    }
}

