/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.SetAttributeQuickFix;
import org.jetbrains.android.refactoring.UnusedResourcesQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintUnusedResourcesInspection
extends AndroidLintInspectionBase {
    public AndroidLintUnusedResourcesInspection() {
        super(AndroidBundle.message("android.lint.inspections.unused.resources", new Object[0]), UnusedResourceDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintUnusedResourcesInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintUnusedResourcesInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintUnusedResourcesInspection", "getQuickFixes"));
        }
        String resource = UnusedResourceDetector.getUnusedResource((String)message, (TextFormat)TextFormat.RAW);
        if (resource != null) {
            String resourceUrl = "@" + resource.substring(2).replace('.', '/');
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new UnusedResourcesQuickFix(null), new UnusedResourcesQuickFix(resource), new SetAttributeQuickFix("Add a tools:keep attribute to mark as implicitly used", "keep", "http://schemas.android.com/tools", resourceUrl)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintUnusedResourcesInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new UnusedResourcesQuickFix(null)};
        if (androidLintQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintUnusedResourcesInspection", "getQuickFixes"));
        }
        return androidLintQuickFixArray;
    }
}

