/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui;

import com.android.tools.adtui.AccordionLayout;
import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.Poller;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseProfilerUiManager {
    protected static final int DEFAULT_MONITOR_MIN_HEIGHT = JBUI.scale((int)0);
    protected static final int DEFAULT_MONITOR_MAX_HEIGHT = JBUI.scale((int)Short.MAX_VALUE);
    protected static final int DEFAULT_MONITOR_PREFERRED_HEIGHT = JBUI.scale((int)200);
    protected BaseSegment myOverviewSegment;
    @NotNull
    protected final Range myTimeCurrentRangeUs;
    @NotNull
    protected final Choreographer myChoreographer;
    @NotNull
    protected final SeriesDataStore myDataStore;
    @NotNull
    protected final EventDispatcher<ProfilerEventListener> myEventDispatcher;
    @Nullable
    protected Set<Poller> myPollerSet;

    public BaseProfilerUiManager(@NotNull Range timeCurrentRangeUs, @NotNull Choreographer choreographer, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> eventDispatcher) {
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "<init>"));
        }
        if (choreographer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "choreographer", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "<init>"));
        }
        if (dataStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStore", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "<init>"));
        }
        if (eventDispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventDispatcher", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "<init>"));
        }
        this.myTimeCurrentRangeUs = timeCurrentRangeUs;
        this.myChoreographer = choreographer;
        this.myDataStore = dataStore;
        this.myEventDispatcher = eventDispatcher;
    }

    @Nullable
    public abstract Set<Poller> createPollers(int var1);

    public void startMonitoring(int pid) {
        assert (this.myPollerSet == null);
        this.myPollerSet = this.createPollers(pid);
        if (this.myPollerSet != null) {
            for (Poller poller : this.myPollerSet) {
                ApplicationManager.getApplication().executeOnPooledThread((Runnable)poller);
            }
        }
    }

    public void stopMonitoring() {
        if (this.myPollerSet != null) {
            for (Poller poller : this.myPollerSet) {
                poller.stop();
            }
            this.myPollerSet = null;
        }
    }

    public void setupOverviewUi(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel) {
        if (toolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbar", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "setupOverviewUi"));
        }
        if (overviewPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overviewPanel", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "setupOverviewUi"));
        }
        this.myOverviewSegment = this.createOverviewSegment(this.myTimeCurrentRangeUs, this.myDataStore, this.myEventDispatcher);
        this.setupAndRegisterSegment(this.myOverviewSegment, DEFAULT_MONITOR_MIN_HEIGHT, DEFAULT_MONITOR_PREFERRED_HEIGHT, DEFAULT_MONITOR_MAX_HEIGHT);
        overviewPanel.add(this.myOverviewSegment);
    }

    public void setupExtendedOverviewUi(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel) {
        if (toolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbar", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "setupExtendedOverviewUi"));
        }
        if (overviewPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overviewPanel", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "setupExtendedOverviewUi"));
        }
        if (this.myOverviewSegment == null) {
            return;
        }
        BaseProfilerUiManager.setSegmentState(overviewPanel, this.myOverviewSegment, AccordionLayout.AccordionState.MAXIMIZE);
        this.myOverviewSegment.toggleView(true);
    }

    public void setupDetailedViewUi(@NotNull JPanel toolbar, @NotNull JPanel detailPanel) {
        if (toolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbar", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "setupDetailedViewUi"));
        }
        if (detailPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailPanel", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "setupDetailedViewUi"));
        }
    }

    public boolean isDetailedViewVerticallySplit() {
        return true;
    }

    public void resetProfiler(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel, @NotNull JPanel detailPanel) {
        if (toolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbar", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "resetProfiler"));
        }
        if (overviewPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overviewPanel", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "resetProfiler"));
        }
        if (detailPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailPanel", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "resetProfiler"));
        }
        if (this.myOverviewSegment == null) {
            return;
        }
        BaseProfilerUiManager.setSegmentState(overviewPanel, this.myOverviewSegment, AccordionLayout.AccordionState.PREFERRED);
        this.myOverviewSegment.toggleView(false);
    }

    @NotNull
    protected abstract BaseSegment createOverviewSegment(@NotNull Range var1, @NotNull SeriesDataStore var2, @NotNull EventDispatcher<ProfilerEventListener> var3);

    protected void setupAndRegisterSegment(@NotNull BaseSegment segment, int minHeight, int preferredHeight, int maxHeight) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "setupAndRegisterSegment"));
        }
        segment.setMinimumSize(new Dimension(0, minHeight));
        segment.setPreferredSize(new Dimension(0, preferredHeight));
        segment.setMaximumSize(new Dimension(0, maxHeight));
        segment.setBorder(BorderFactory.createLineBorder((Color)JBColor.GRAY));
        ArrayList<Animatable> segmentAnimatables = new ArrayList<Animatable>();
        segment.createComponentsList(segmentAnimatables);
        this.myChoreographer.register(segmentAnimatables);
        segment.initializeComponents();
    }

    protected static void setSegmentState(@NotNull JPanel accordionPanel, @NotNull BaseSegment segment, @NotNull AccordionLayout.AccordionState state) {
        if (accordionPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accordionPanel", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "setSegmentState"));
        }
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "setSegmentState"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/monitor/ui/BaseProfilerUiManager", "setSegmentState"));
        }
        AccordionLayout layout = (AccordionLayout)accordionPanel.getLayout();
        if (layout != null) {
            layout.setState((Component)segment, state);
        }
    }

    public static enum ProfilerType {
        EVENT,
        NETWORK,
        MEMORY,
        CPU,
        GPU,
        ENERGY;

    }
}

