/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.cpu.view;

import com.android.tools.adtui.AnimatedRange;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.common.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.datastore.SeriesDataType;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseLineChartSegment;
import com.android.tools.idea.monitor.ui.BaseProfilerUiManager;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class CpuUsageSegment
extends BaseLineChartSegment {
    private static final String SEGMENT_NAME = "CPU";
    private static final String MY_PROCESS_SERIES_LABEL = "My Process";
    private static final String OTHER_PROCESSES_SERIES_LABEL = "Other Processes";
    private static final String THREADS_SERIES_LABEL = "Threads";
    private static final SingleUnitAxisFormatter CPU_USAGE_AXIS_SIMPLE = new SingleUnitAxisFormatter(1, 5, 10, "%");
    private static final SingleUnitAxisFormatter CPU_USAGE_AXIS = new SingleUnitAxisFormatter(10, 10, 10, "%");
    private static final SingleUnitAxisFormatter NUM_THREADS_AXIS = new SingleUnitAxisFormatter(5, 10, 1, "");
    private static final Color MY_PROCESS_LINE_COLOR = new JBColor(8766608, 8766608);
    private static final Color OTHER_PROCESSES_LINE_COLOR = new JBColor(13228257, 13228257);
    private static final Color THREADS_LINE_COLOR = new JBColor(5935680, 5935680);
    private boolean myIsExpanded;

    public CpuUsageSegment(@NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/cpu/view/CpuUsageSegment", "<init>"));
        }
        if (dataStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStore", "com/android/tools/idea/monitor/ui/cpu/view/CpuUsageSegment", "<init>"));
        }
        if (dispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatcher", "com/android/tools/idea/monitor/ui/cpu/view/CpuUsageSegment", "<init>"));
        }
        super(SEGMENT_NAME, timeCurrentRangeUs, dataStore, (BaseAxisFormatter)CPU_USAGE_AXIS_SIMPLE, (BaseAxisFormatter)CPU_USAGE_AXIS, (BaseAxisFormatter)NUM_THREADS_AXIS, new AnimatedRange(0.0, 100.0), null, dispatcher);
    }

    @Override
    public BaseProfilerUiManager.ProfilerType getProfilerType() {
        return BaseProfilerUiManager.ProfilerType.CPU;
    }

    @Override
    protected void updateChartLines(boolean isExpanded) {
        this.myIsExpanded = isExpanded;
        this.addCpuUsageLine(SeriesDataType.CPU_MY_PROCESS, MY_PROCESS_SERIES_LABEL, MY_PROCESS_LINE_COLOR);
        if (isExpanded) {
            this.addCpuUsageLine(SeriesDataType.CPU_OTHER_PROCESSES, OTHER_PROCESSES_SERIES_LABEL, OTHER_PROCESSES_LINE_COLOR);
            this.addRightAxisLine(SeriesDataType.CPU_THREADS, THREADS_SERIES_LABEL, new LineConfig(THREADS_LINE_COLOR).setStepped(true));
        }
    }

    private void addCpuUsageLine(SeriesDataType type, String label, Color lineColor) {
        this.addLeftAxisLine(type, label, new LineConfig(lineColor).setFilled(true).setStacked(true));
    }

    @Override
    protected void handleMultiClickEvent() {
        if (!this.myIsExpanded) {
            ((ProfilerEventListener)this.mEventDispatcher.getMulticaster()).profilerExpanded(this.getProfilerType());
        }
    }
}

