/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.importing.ArchiveToGradleModuleModel;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.swing.SelectedProperty;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.android.tools.idea.ui.properties.swing.VisibleProperty;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.ValidatorPanel;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class ArchiveToGradleModuleStep
extends SkippableWizardStep<ArchiveToGradleModuleModel> {
    private static final Set<String> SUPPORTED_EXTENSIONS = ImmutableSet.of((Object)"jar", (Object)"aar");
    private final ListenerManager myListeners;
    private final BindingsManager myBindings;
    private ValidatorPanel myValidatorPanel;
    private JPanel myPanel;
    private JTextField myGradlePath;
    private TextFieldWithBrowseButton myArchivePath;
    private JCheckBox myRemoveOriginalFileCheckBox;

    public ArchiveToGradleModuleStep(@NotNull ArchiveToGradleModuleModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep", "<init>"));
        }
        super(model, AndroidBundle.message("android.wizard.module.import.library.title", new Object[0]));
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myBindings = new BindingsManager();
        this.myValidatorPanel = new ValidatorPanel(this, this.myPanel);
        this.myArchivePath.addBrowseFolderListener(AndroidBundle.message("android.wizard.module.import.library.browse.title", new Object[0]), AndroidBundle.message("android.wizard.module.import.library.browse.description", new Object[0]), model.getProject(), new FileChooserDescriptor(true, false, true, true, false, false).withFileFilter(ArchiveToGradleModuleStep::isValidExtension));
        this.myBindings.bindTwoWay(model.archive(), new TextProperty(this.myArchivePath.getTextField()));
        this.myBindings.bindTwoWay(model.gradlePath(), new TextProperty(this.myGradlePath));
        this.myBindings.bindTwoWay(model.moveArchive(), new SelectedProperty(this.myRemoveOriginalFileCheckBox));
        this.myBindings.bind(new VisibleProperty(this.myRemoveOriginalFileCheckBox), model.inModule());
        this.myListeners.listen(model.archive(), updated -> {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep", "lambda$new$0"));
            }
            model.gradlePath().set(Files.getNameWithoutExtension((String)((String)model.archive().get())));
        });
    }

    static boolean isValidExtension(VirtualFile file) {
        String extension = file.getExtension();
        return extension != null && SUPPORTED_EXTENSIONS.contains(extension.toLowerCase());
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep", "onWizardStarting"));
        }
        ArchiveToGradleModuleModel model = (ArchiveToGradleModuleModel)this.getModel();
        this.myValidatorPanel.registerValidator(model.archive(), new ArchiveValidator());
        this.myValidatorPanel.registerValidator(model.gradlePath(), new GradleValidator(model.getProject()));
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        ValidatorPanel validatorPanel = this.myValidatorPanel;
        if (validatorPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep", "getComponent"));
        }
        return validatorPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusComponent() {
        JTextField jTextField = this.myArchivePath.getTextField();
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep", "getPreferredFocusComponent"));
        }
        return jTextField;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep", "canGoForward"));
        }
        return observableBool;
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(96, 16, 0, 0), -1, -1, false, false));
        this.myArchivePath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myGradlePath = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("File name:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Subproject name:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRemoveOriginalFileCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Remove original file");
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    static final class GradleValidator
    implements Validator<String> {
        private Project myProject;

        GradleValidator(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$GradleValidator", "<init>"));
            }
            this.myProject = project;
        }

        @Override
        @NotNull
        public Validator.Result validate(@NotNull String gradlePath) {
            if (gradlePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$GradleValidator", "validate"));
            }
            if (Strings.isNullOrEmpty((String)gradlePath)) {
                Validator.Result result = new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.no.name", new Object[0]));
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$GradleValidator", "validate"));
                }
                return result;
            }
            int invalidCharIndex = GradleUtil.isValidGradlePath(gradlePath);
            if (invalidCharIndex >= 0) {
                Validator.Result result = new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.bad.name", Character.valueOf(gradlePath.charAt(invalidCharIndex))));
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$GradleValidator", "validate"));
                }
                return result;
            }
            if (GradleUtil.hasModule(this.myProject, gradlePath, true)) {
                Validator.Result result = new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.taken.name", gradlePath));
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$GradleValidator", "validate"));
                }
                return result;
            }
            Validator.Result result = Validator.Result.OK;
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$GradleValidator", "validate"));
            }
            return result;
        }
    }

    static final class ArchiveValidator
    implements Validator<String> {
        ArchiveValidator() {
        }

        @Override
        @NotNull
        public Validator.Result validate(@NotNull String archive) {
            if (archive == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archive", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$ArchiveValidator", "validate"));
            }
            if (Strings.isNullOrEmpty((String)archive)) {
                Validator.Result result = new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.no.path", new Object[0]));
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$ArchiveValidator", "validate"));
                }
                return result;
            }
            File archiveFile = new File(archive);
            if (!archiveFile.isFile()) {
                Validator.Result result = new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.bad.path", new Object[0]));
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$ArchiveValidator", "validate"));
                }
                return result;
            }
            VirtualFile archiveVirtualFile = VfsUtil.findFileByIoFile((File)archiveFile, (boolean)true);
            if (!ArchiveToGradleModuleStep.isValidExtension(archiveVirtualFile)) {
                Validator.Result result = new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.import.library.bad.extension", new Object[0]));
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$ArchiveValidator", "validate"));
                }
                return result;
            }
            Validator.Result result = Validator.Result.OK;
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleStep$ArchiveValidator", "validate"));
            }
            return result;
        }
    }
}

