/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.npw.AsyncValidator;
import com.android.tools.idea.npw.importing.ImportUIUtil;
import com.android.tools.idea.npw.importing.ModuleImportSettings;
import com.android.tools.idea.npw.importing.ModuleWizardStepAdapter;
import com.android.tools.idea.npw.importing.ModulesTable;
import com.android.tools.idea.npw.importing.SourceToGradleModuleModel;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObjectProperty;
import com.android.tools.idea.ui.properties.core.ObjectValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.swing.IconProperty;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.android.tools.idea.ui.properties.swing.VisibleProperty;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SourceToGradleModuleStep
extends SkippableWizardStep<SourceToGradleModuleModel> {
    private final ListenerManager myListeners;
    private final BindingsManager myBindings;
    private final BoolProperty myCanGoForward;
    private final ObjectProperty<PathValidationResult> myPageValidationResult;
    @NotNull
    private PathValidationResult myLocationValidationResult;
    @Nullable
    private ModelWizard.Facade myFacade;
    private JPanel myPanel;
    private TextFieldWithBrowseButton mySourceLocation;
    private JBLabel myErrorWarning;
    private AsyncProcessIcon myValidationProgress;
    private JBScrollPane myModulesScroller;
    private ModulesTable myModulesPanel;
    private JLabel myRequiredModulesLabel;
    private JLabel myModuleNameLabel;
    private JTextField myModuleNameField;
    private JLabel myPrimaryModuleState;

    public SourceToGradleModuleStep(@NotNull SourceToGradleModuleModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "<init>"));
        }
        super(model, AndroidBundle.message("android.wizard.module.import.source.title", new Object[0]));
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myBindings = new BindingsManager();
        this.myCanGoForward = new BoolValueProperty();
        this.myPageValidationResult = new ObjectValueProperty<PathValidationResult>(PathValidationResult.ofType(PathValidationResult.ResultType.OK));
        this.myLocationValidationResult = PathValidationResult.ofType(PathValidationResult.ResultType.OK);
        this.mySourceLocation.addBrowseFolderListener(AndroidBundle.message("android.wizard.module.import.source.browse.title", new Object[0]), AndroidBundle.message("android.wizard.module.import.source.browse.description", new Object[0]), ((SourceToGradleModuleModel)this.getModel()).getProject(), FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor());
        this.myBindings.bindTwoWay(new TextProperty(this.mySourceLocation.getTextField()), model.sourceLocation());
        this.myBindings.bind(new VisibleProperty((JComponent)this.myValidationProgress), this.myPageValidationResult.transform(PathValidationResult::isValidating));
        this.myBindings.bind(new VisibleProperty((JComponent)this.myErrorWarning), this.myPageValidationResult.transform(result -> result.getIcon() != null));
        this.myBindings.bind(new TextProperty((JLabel)this.myErrorWarning), this.myPageValidationResult.transform(PathValidationResult::getMessage));
        this.myBindings.bind(new IconProperty((JLabel)this.myErrorWarning), this.myPageValidationResult.transform(result -> Optional.ofNullable(result.getIcon())));
        this.myErrorWarning.setBorder(BorderFactory.createEmptyBorder(16, 0, 0, 0));
        this.myPanel.setBorder(new EmptyBorder(UIUtil.PANEL_REGULAR_INSETS));
        this.myModulesPanel.bindPrimaryModuleEntryComponents(new PrimaryModuleImportSettings(), this.myRequiredModulesLabel);
        this.myModulesPanel.addPropertyChangeListener("selectedModules", event -> {
            if ("selectedModules".equals(event.getPropertyName())) {
                this.updateStepStatus();
            }
        });
        AsyncValidator<PathValidationResult> validator = new AsyncValidator<PathValidationResult>(ApplicationManager.getApplication()){

            @Override
            protected void showValidationResult(@NotNull PathValidationResult result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep$1", "showValidationResult"));
                }
                SourceToGradleModuleStep.this.applyValidationResult(result);
            }

            @Override
            @NotNull
            protected PathValidationResult validate() {
                SourceToGradleModuleStep.this.myPageValidationResult.set(PathValidationResult.ofType(PathValidationResult.ResultType.VALIDATING));
                PathValidationResult pathValidationResult = SourceToGradleModuleStep.this.checkPath((String)((SourceToGradleModuleModel)SourceToGradleModuleStep.this.getModel()).sourceLocation().get());
                if (pathValidationResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep$1", "validate"));
                }
                return pathValidationResult;
            }
        };
        this.myListeners.listen(model.sourceLocation(), source -> validator.invalidate());
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "onWizardStarting"));
        }
        this.myFacade = wizard;
    }

    @Override
    protected void onProceeding() {
        ((SourceToGradleModuleModel)this.getModel()).setModulesToImport(this.myModulesPanel.getSelectedModulesMap());
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        BoolProperty boolProperty = this.myCanGoForward;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "canGoForward"));
        }
        return boolProperty;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "getComponent"));
        }
        return jPanel;
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        WizardContext context = ((SourceToGradleModuleModel)this.getModel()).getContext();
        ArrayList<ModuleWizardStepAdapter> wrappedSteps = new ArrayList<ModuleWizardStepAdapter>();
        for (ModuleImporter importer : ModuleImporter.getAllImporters(context)) {
            for (ModuleWizardStep moduleWizardStep : importer.createWizardSteps()) {
                wrappedSteps.add(new ModuleWizardStepAdapter(context, moduleWizardStep));
            }
        }
        ArrayList<ModuleWizardStepAdapter> arrayList = wrappedSteps;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "createDependentSteps"));
        }
        return arrayList;
    }

    private void applyValidationResult(@NotNull PathValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "applyValidationResult"));
        }
        this.myLocationValidationResult = result;
        this.myModulesPanel.setModules(((SourceToGradleModuleModel)this.getModel()).getProject(), result.myVFile, result.myModules);
        this.myModulesScroller.setVisible(this.myModulesPanel.getComponentCount() > 0);
        ModuleImporter.setImporter(((SourceToGradleModuleModel)this.getModel()).getContext(), result.myImporter);
        assert (this.myFacade != null);
        this.myFacade.updateNavigationProperties();
        this.updateStepStatus();
    }

    private void updateStepStatus() {
        PathValidationResult result = this.myLocationValidationResult;
        if (result.myStatus.severity != MessageType.ERROR && this.myModulesPanel.getSelectedModules().isEmpty()) {
            result = PathValidationResult.ofType(PathValidationResult.ResultType.NO_MODULES_SELECTED);
        }
        this.myPageValidationResult.set(result);
        this.myCanGoForward.set(result.myStatus.severity != MessageType.ERROR && !result.isValidating() && this.myModulesPanel.canImport());
    }

    private void createUIComponents() {
        this.myValidationProgress = new AsyncProcessIcon("validation");
    }

    @NotNull
    PathValidationResult checkPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "checkPath"));
        }
        if (Strings.isNullOrEmpty((String)path)) {
            PathValidationResult pathValidationResult = PathValidationResult.ofType(PathValidationResult.ResultType.EMPTY_PATH);
            if (pathValidationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "checkPath"));
            }
            return pathValidationResult;
        }
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
        if (vFile == null || !vFile.exists()) {
            PathValidationResult pathValidationResult = PathValidationResult.ofType(PathValidationResult.ResultType.DOES_NOT_EXIST);
            if (pathValidationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "checkPath"));
            }
            return pathValidationResult;
        }
        if (this.isProjectOrModule(vFile)) {
            PathValidationResult pathValidationResult = PathValidationResult.ofType(PathValidationResult.ResultType.IS_PROJECT_OR_MODULE);
            if (pathValidationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "checkPath"));
            }
            return pathValidationResult;
        }
        ModuleImporter importer = ModuleImporter.importerForLocation(((SourceToGradleModuleModel)this.getModel()).getContext(), vFile);
        if (!importer.isValid()) {
            PathValidationResult pathValidationResult = PathValidationResult.ofType(PathValidationResult.ResultType.NOT_ADT_OR_GRADLE);
            if (pathValidationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "checkPath"));
            }
            return pathValidationResult;
        }
        Collection modules = (Collection)ApplicationManager.getApplication().runReadAction(() -> {
            try {
                return importer.findModules(vFile);
            }
            catch (IOException e) {
                Logger.getInstance(SourceToGradleModuleStep.class).error((Throwable)e);
                return null;
            }
        });
        if (modules == null) {
            PathValidationResult pathValidationResult = PathValidationResult.ofType(PathValidationResult.ResultType.INTERNAL_ERROR);
            if (pathValidationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "checkPath"));
            }
            return pathValidationResult;
        }
        TreeSet missingSourceModuleNames = Sets.newTreeSet();
        for (ModuleToImport module : modules) {
            if (module.location != null && module.location.exists()) continue;
            missingSourceModuleNames.add(module.name);
        }
        if (!missingSourceModuleNames.isEmpty()) {
            PathValidationResult pathValidationResult = new PathValidationResult(PathValidationResult.ResultType.MISSING_SUBPROJECTS, vFile, importer, modules, missingSourceModuleNames);
            if (pathValidationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "checkPath"));
            }
            return pathValidationResult;
        }
        PathValidationResult pathValidationResult = new PathValidationResult(PathValidationResult.ResultType.OK, vFile, importer, modules, null);
        if (pathValidationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "checkPath"));
        }
        return pathValidationResult;
    }

    private boolean isProjectOrModule(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep", "isProjectOrModule"));
        }
        Project project = ((SourceToGradleModuleModel)this.getModel()).getProject();
        if (dir.equals(project.getBaseDir())) {
            return true;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!ModuleUtilCore.isModuleDir((Module)module, (VirtualFile)dir)) continue;
            return true;
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        JLabel jLabel3;
        JBLabel jBLabel;
        ModulesTable modulesTable;
        JBScrollPane jBScrollPane;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySourceLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 2, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myModulesScroller = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jBScrollPane.setVisible(false);
        jPanel.add((Component)jBScrollPane, new GridConstraints(5, 0, 1, 4, 0, 3, 7, 3, null, null, null));
        this.myModulesPanel = modulesTable = new ModulesTable();
        jBScrollPane.setViewportView((Component)((Object)modulesTable));
        this.myErrorWarning = jBLabel = new JBLabel();
        jBLabel.setText("An error or warning");
        jPanel.add((Component)jBLabel, new GridConstraints(6, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Source directory:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myValidationProgress;
        asyncProcessIcon.setVisible(false);
        jPanel.add((Component)asyncProcessIcon, new GridConstraints(6, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 2, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myRequiredModulesLabel = jLabel3 = new JLabel();
        jLabel3.setText("Additional required modules:");
        jPanel.add((Component)jLabel3, new GridConstraints(4, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 1, new Dimension(-1, 16), new Dimension(-1, 40), new Dimension(-1, 40)));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 2, 1, 2, 0, 2, 1, 3, null, new Dimension(-1, 120), new Dimension(-1, 120)));
        this.myModuleNameLabel = jLabel2 = new JLabel();
        jLabel2.setText("Module name:");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myModuleNameField = jTextField = new JTextField();
        jTextField.setColumns(15);
        jPanel.add((Component)jTextField, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, new Dimension(150, -1), null));
        this.myPrimaryModuleState = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(2, 3, 1, 1, 8, 0, 6, 0, null, null, null));
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private final class PrimaryModuleImportSettings
    implements ModuleImportSettings {
        private PrimaryModuleImportSettings() {
        }

        @Override
        public boolean isModuleSelected() {
            return true;
        }

        @Override
        public void setModuleSelected(boolean selected) {
        }

        @Override
        @NotNull
        public String getModuleName() {
            String string = SourceToGradleModuleStep.this.myModuleNameField.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep$PrimaryModuleImportSettings", "getModuleName"));
            }
            return string;
        }

        @Override
        public void setModuleName(@NotNull String moduleName) {
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep$PrimaryModuleImportSettings", "setModuleName"));
            }
            if (!Objects.equal((Object)moduleName, (Object)SourceToGradleModuleStep.this.myModuleNameField.getText())) {
                SourceToGradleModuleStep.this.myModuleNameField.setText(moduleName);
            }
        }

        @Override
        public void setModuleSourcePath(String relativePath) {
        }

        @Override
        public void setCanToggleModuleSelection(boolean b) {
        }

        @Override
        public void setCanRenameModule(boolean canRenameModule) {
            SourceToGradleModuleStep.this.myModuleNameField.setEnabled(canRenameModule);
        }

        @Override
        public void setValidationStatus(@Nullable MessageType statusSeverity, @Nullable String statusDescription) {
            SourceToGradleModuleStep.this.myPrimaryModuleState.setIcon(statusSeverity == null ? null : statusSeverity.getDefaultIcon());
            SourceToGradleModuleStep.this.myPrimaryModuleState.setText(Strings.nullToEmpty((String)statusDescription));
        }

        @Override
        public void setVisible(boolean visible) {
            SourceToGradleModuleStep.this.myPrimaryModuleState.setVisible(visible);
            SourceToGradleModuleStep.this.myModuleNameField.setVisible(visible);
            SourceToGradleModuleStep.this.myModuleNameLabel.setVisible(visible);
        }

        @Override
        public void addActionListener(final @NotNull ActionListener actionListener) {
            if (actionListener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionListener", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep$PrimaryModuleImportSettings", "addActionListener"));
            }
            SourceToGradleModuleStep.this.myModuleNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep$PrimaryModuleImportSettings$1", "textChanged"));
                    }
                    actionListener.actionPerformed(new ActionEvent((Object)this, 1001, "changed"));
                }
            });
        }
    }

    static final class PathValidationResult {
        @NotNull
        public final ResultType myStatus;
        @Nullable
        public final VirtualFile myVFile;
        @Nullable
        public final ModuleImporter myImporter;
        @Nullable
        public final Collection<ModuleToImport> myModules;
        @Nullable
        public final Set<String> myDetails;

        private PathValidationResult(@NotNull ResultType status, @Nullable VirtualFile vFile, @Nullable ModuleImporter importer, @Nullable Collection<ModuleToImport> modules, @Nullable Set<String> details) {
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep$PathValidationResult", "<init>"));
            }
            this.myStatus = status;
            this.myVFile = vFile;
            this.myImporter = importer;
            this.myModules = modules;
            this.myDetails = details;
        }

        @Nullable
        public Icon getIcon() {
            return this.myStatus.getIcon();
        }

        public String getMessage() {
            return this.myStatus.getMessage(this.myDetails);
        }

        public boolean isValidating() {
            return this.myStatus == ResultType.VALIDATING;
        }

        public static PathValidationResult ofType(ResultType status) {
            return new PathValidationResult(status, null, null, null, null);
        }

        static enum ResultType {
            OK(null, null),
            EMPTY_PATH(AndroidBundle.message("android.wizard.module.import.source.browse.no.location", new Object[0]), MessageType.ERROR),
            DOES_NOT_EXIST(AndroidBundle.message("android.wizard.module.import.source.browse.invalid.location", new Object[0]), MessageType.ERROR),
            IS_PROJECT_OR_MODULE(AndroidBundle.message("android.wizard.module.import.source.browse.taken.location", new Object[0]), MessageType.ERROR),
            MISSING_SUBPROJECTS(null, MessageType.WARNING),
            NO_MODULES_SELECTED(AndroidBundle.message("android.wizard.module.import.source.browse.no.modules", new Object[0]), MessageType.ERROR),
            NOT_ADT_OR_GRADLE(AndroidBundle.message("android.wizard.module.import.source.browse.cant.import", new Object[0]), MessageType.ERROR),
            INTERNAL_ERROR(AndroidBundle.message("android.wizard.module.import.source.browse.error", new Object[0]), MessageType.ERROR),
            VALIDATING(AndroidBundle.message("android.wizard.module.import.source.browse.validating", new Object[0]), null);

            @Nullable
            public final MessageType severity;
            @Nullable
            private final String message;

            private ResultType(String message, MessageType severity) {
                this.message = message;
                this.severity = severity;
            }

            @Nullable
            public Icon getIcon() {
                return this.severity == null ? null : this.severity.getDefaultIcon();
            }

            @NotNull
            public String getMessage(@Nullable Set<String> details) {
                if (this == MISSING_SUBPROJECTS) {
                    String formattedMessage = ImportUIUtil.formatElementListString(details, AndroidBundle.message("android.wizard.module.import.source.browse.bad.modules.1", new Object[0]), AndroidBundle.message("android.wizard.module.import.source.browse.bad.modules.2", new Object[0]), AndroidBundle.message("android.wizard.module.import.source.browse.bad.modules.more", new Object[0]));
                    String string = WizardUtils.toHtmlString(formattedMessage);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep$PathValidationResult$ResultType", "getMessage"));
                    }
                    return string;
                }
                String string = Strings.nullToEmpty((String)this.message);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/SourceToGradleModuleStep$PathValidationResult$ResultType", "getMessage"));
                }
                return string;
            }
        }
    }
}

