/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectInfo {
    @NotNull
    private final Project myProject;

    @NotNull
    public static AndroidProjectInfo getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/project/AndroidProjectInfo", "getInstance"));
        }
        AndroidProjectInfo androidProjectInfo = (AndroidProjectInfo)ServiceManager.getService((Project)project, AndroidProjectInfo.class);
        if (androidProjectInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/project/AndroidProjectInfo", "getInstance"));
        }
        return androidProjectInfo;
    }

    public AndroidProjectInfo(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/project/AndroidProjectInfo", "<init>"));
        }
        this.myProject = project;
    }

    public boolean requiresAndroidModel() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet == null || !androidFacet.requiresAndroidModel()) continue;
            return true;
        }
        return false;
    }
}

