/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Sets;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImagePool {
    public static final Image NULL_POOLED_IMAGE = new Image(){

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public int getHeight() {
            return 0;
        }

        @Override
        public void drawImageTo(@NotNull Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/rendering/ImagePool$1", "drawImageTo"));
            }
        }

        @Override
        @Nullable
        public BufferedImage getCopy() {
            return null;
        }
    };
    private static final boolean DEBUG = false;
    private static final EvictingQueue<SoftReference<BufferedImage>> NULL_EVICTING_QUEUE = EvictingQueue.create((int)0);
    private static final BiFunction<Integer, Integer, Function<Integer, Integer>> DEFAULT_SIZING_POLICY = (w, h) -> type -> {
        if (w * h < 1000) {
            return 0;
        }
        return 50000000 / (w * h);
    };
    private final HashMap<String, EvictingQueue<SoftReference<BufferedImage>>> myPool;
    private final FinalizableReferenceQueue myFinalizableReferenceQueue;
    private final Set<Reference<?>> myReferences;
    private final BiFunction<Integer, Integer, Function<Integer, Integer>> myQueueSizingPolicy;
    private boolean isDisposed;

    @NotNull
    private static String getPoolKey(int w, int h, int type) {
        String string = String.format("%dx%d-%d", w, h, type);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ImagePool", "getPoolKey"));
        }
        return string;
    }

    @NotNull
    private EvictingQueue<SoftReference<BufferedImage>> getTypeQueue(int w, int h, int type) {
        String poolKey = ImagePool.getPoolKey(w, h, type);
        EvictingQueue evictingQueue = this.myPool.computeIfAbsent(poolKey, k -> {
            int size = this.myQueueSizingPolicy.apply(w, h).apply(type);
            if (size == 0) {
                return NULL_EVICTING_QUEUE;
            }
            return EvictingQueue.create((int)size);
        });
        if (evictingQueue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ImagePool", "getTypeQueue"));
        }
        return evictingQueue;
    }

    public ImagePool(@NotNull BiFunction<Integer, Integer, Function<Integer, Integer>> queueSizingPolicy) {
        if (queueSizingPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queueSizingPolicy", "com/android/tools/idea/rendering/ImagePool", "<init>"));
        }
        this.myPool = new HashMap();
        this.myFinalizableReferenceQueue = new FinalizableReferenceQueue();
        this.myReferences = Sets.newConcurrentHashSet();
        this.isDisposed = false;
        this.myQueueSizingPolicy = queueSizingPolicy;
    }

    public ImagePool() {
        this(DEFAULT_SIZING_POLICY);
    }

    @NotNull
    ImageImpl create(final int w, final int h, final int type, final @Nullable Consumer<BufferedImage> freedCallback) {
        BufferedImage image;
        assert (!this.isDisposed) : "ImagePool already disposed";
        EvictingQueue<SoftReference<BufferedImage>> queue = this.getTypeQueue(w, h, type);
        try {
            SoftReference imageRef = (SoftReference)queue.remove();
            while ((image = (BufferedImage)imageRef.get()) == null) {
                imageRef = (SoftReference)queue.remove();
            }
            Graphics2D g = image.createGraphics();
            g.setComposite(AlphaComposite.Clear);
            g.fillRect(0, 0, w, h);
            g.dispose();
        }
        catch (NoSuchElementException e) {
            image = new BufferedImage(w, h, type);
        }
        ImageImpl pooledImage = new ImageImpl(image);
        final BufferedImage imagePointer = image;
        FinalizablePhantomReference<Image> reference = new FinalizablePhantomReference<Image>((Image)pooledImage, this.myFinalizableReferenceQueue){

            public void finalizeReferent() {
                ImagePool.this.myReferences.remove((Object)this);
                ImagePool.this.getTypeQueue(w, h, type).add(new SoftReference<BufferedImage>(imagePointer));
                if (freedCallback != null) {
                    freedCallback.accept(imagePointer);
                }
            }
        };
        this.myReferences.add((Reference<?>)reference);
        ImageImpl imageImpl = pooledImage;
        if (imageImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ImagePool", "create"));
        }
        return imageImpl;
    }

    @NotNull
    public Image create(int w, int h, int type) {
        ImageImpl imageImpl = this.create(w, h, type, null);
        if (imageImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ImagePool", "create"));
        }
        return imageImpl;
    }

    @NotNull
    public Image copyOf(@Nullable BufferedImage origin) {
        if (origin == null) {
            Image image = NULL_POOLED_IMAGE;
            if (image == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ImagePool", "copyOf"));
            }
            return image;
        }
        int w = origin.getWidth();
        int h = origin.getHeight();
        int type = origin.getType();
        ImageImpl image = this.create(w, h, type, null);
        image.drawFrom(origin);
        ImageImpl imageImpl = image;
        if (imageImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ImagePool", "copyOf"));
        }
        return imageImpl;
    }

    public void dispose() {
        this.isDisposed = true;
        this.myFinalizableReferenceQueue.close();
        this.myReferences.clear();
        this.myPool.clear();
    }

    public static class ImageImpl
    implements Image {
        @NotNull
        BufferedImage myBuffer;

        private ImageImpl(@NotNull BufferedImage image) {
            if (image == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/rendering/ImagePool$ImageImpl", "<init>"));
            }
            this.myBuffer = image;
        }

        @Override
        public int getWidth() {
            return this.myBuffer.getWidth();
        }

        @Override
        public int getHeight() {
            return this.myBuffer.getHeight();
        }

        @Override
        public void drawImageTo(@NotNull Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/rendering/ImagePool$ImageImpl", "drawImageTo"));
            }
            g.drawImage(this.myBuffer, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
        }

        @Override
        @NotNull
        public BufferedImage getCopy() {
            WritableRaster raster = this.myBuffer.copyData(this.myBuffer.getRaster().createCompatibleWritableRaster());
            BufferedImage bufferedImage = new BufferedImage(this.myBuffer.getColorModel(), raster, this.myBuffer.isAlphaPremultiplied(), null);
            if (bufferedImage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ImagePool$ImageImpl", "getCopy"));
            }
            return bufferedImage;
        }

        void drawFrom(@NotNull BufferedImage origin) {
            if (origin == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/android/tools/idea/rendering/ImagePool$ImageImpl", "drawFrom"));
            }
            Graphics g = this.myBuffer.getGraphics();
            try {
                g.drawImage(origin, 0, 0, null);
            }
            finally {
                g.dispose();
            }
        }
    }

    public static interface Image {
        public int getWidth();

        public int getHeight();

        public void drawImageTo(@NotNull Graphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

        default public void drawImageTo(@NotNull Graphics g, int x, int y, int w, int h) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/rendering/ImagePool$Image", "drawImageTo"));
            }
            this.drawImageTo(g, x, y, w, h, 0, 0, this.getWidth(), this.getHeight());
        }

        default public void drawImageTo(@NotNull BufferedImage destination) {
            if (destination == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/rendering/ImagePool$Image", "drawImageTo"));
            }
            Graphics g = destination.getGraphics();
            try {
                this.drawImageTo(g, 0, 0, destination.getWidth(), destination.getHeight());
            }
            finally {
                g.dispose();
            }
        }

        @Nullable
        public BufferedImage getCopy();
    }
}

