/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.util.LaunchUtils;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchCompatibilityCheckerImpl
implements LaunchCompatibilityChecker {
    private final AndroidVersion myMinSdkVersion;
    private final IAndroidTarget myProjectTarget;
    private final EnumSet<IDevice.HardwareFeature> myRequiredHardwareFeatures;
    private final Set<String> mySupportedAbis;

    public LaunchCompatibilityCheckerImpl(@NotNull AndroidVersion minSdkVersion, @NotNull IAndroidTarget target, @NotNull EnumSet<IDevice.HardwareFeature> requiredHardwareFeatures, @Nullable Set<String> supportedAbis) {
        if (minSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minSdkVersion", "com/android/tools/idea/run/LaunchCompatibilityCheckerImpl", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/run/LaunchCompatibilityCheckerImpl", "<init>"));
        }
        if (requiredHardwareFeatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredHardwareFeatures", "com/android/tools/idea/run/LaunchCompatibilityCheckerImpl", "<init>"));
        }
        this.myMinSdkVersion = minSdkVersion;
        this.myProjectTarget = target;
        this.myRequiredHardwareFeatures = requiredHardwareFeatures;
        this.mySupportedAbis = supportedAbis;
    }

    @Override
    @NotNull
    public LaunchCompatibility validate(@NotNull AndroidDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/LaunchCompatibilityCheckerImpl", "validate"));
        }
        LaunchCompatibility launchCompatibility = device.canRun(this.myMinSdkVersion, this.myProjectTarget, this.myRequiredHardwareFeatures, this.mySupportedAbis);
        if (launchCompatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchCompatibilityCheckerImpl", "validate"));
        }
        return launchCompatibility;
    }

    public static LaunchCompatibilityChecker create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/LaunchCompatibilityCheckerImpl", "create"));
        }
        AndroidVersion minSdkVersion = AndroidModuleInfo.get(facet).getRuntimeMinSdkVersion();
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            throw new IllegalStateException("Android platform not set for module: " + facet.getModule().getName());
        }
        EnumSet<IDevice.HardwareFeature> requiredHardwareFeatures = LaunchUtils.isWatchFeatureRequired(facet) ? EnumSet.of(IDevice.HardwareFeature.WATCH) : EnumSet.noneOf(IDevice.HardwareFeature.class);
        Set supportedAbis = facet.getAndroidModel() instanceof AndroidModuleModel ? ((AndroidModuleModel)facet.getAndroidModel()).getSelectedVariant().getMainArtifact().getAbiFilters() : null;
        return new LaunchCompatibilityCheckerImpl(minSdkVersion, platform.getTarget(), requiredHardwareFeatures, supportedAbis);
    }
}

