/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeSdks {
    @NonNls
    public static final String MAC_JDK_CONTENT_PATH = "/Contents/Home";
    @NonNls
    private static final String ANDROID_SDK_PATH_KEY = "android.sdk.path";
    @NotNull
    private final AndroidSdks myAndroidSdks;
    @NotNull
    private final Jdks myJdks;
    @NotNull
    private final EmbeddedDistributionPaths myEmbeddedDistributionPaths;
    @NotNull
    private final IdeInfo myIdeInfo;

    @NotNull
    public static IdeSdks getInstance() {
        IdeSdks ideSdks = (IdeSdks)ServiceManager.getService(IdeSdks.class);
        if (ideSdks == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "getInstance"));
        }
        return ideSdks;
    }

    public IdeSdks(@NotNull AndroidSdks androidSdks, @NotNull Jdks jdks, @NotNull EmbeddedDistributionPaths embeddedDistributionPaths, @NotNull IdeInfo ideInfo) {
        if (androidSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdks", "com/android/tools/idea/sdk/IdeSdks", "<init>"));
        }
        if (jdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdks", "com/android/tools/idea/sdk/IdeSdks", "<init>"));
        }
        if (embeddedDistributionPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "embeddedDistributionPaths", "com/android/tools/idea/sdk/IdeSdks", "<init>"));
        }
        if (ideInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideInfo", "com/android/tools/idea/sdk/IdeSdks", "<init>"));
        }
        this.myAndroidSdks = androidSdks;
        this.myJdks = jdks;
        this.myEmbeddedDistributionPaths = embeddedDistributionPaths;
        this.myIdeInfo = ideInfo;
    }

    @Nullable
    public File getAndroidSdkPath() {
        File candidate;
        File candidate2;
        String sdkHome = null;
        Sdk sdk = this.getFirstAndroidSdk();
        if (sdk != null) {
            sdkHome = sdk.getHomePath();
        }
        if (sdkHome != null && this.isValidAndroidSdkPath(candidate2 = new File(FileUtil.toSystemDependentName((String)sdkHome)))) {
            return candidate2;
        }
        PropertiesComponent component = PropertiesComponent.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
        String sdkPath = component.getValue(ANDROID_SDK_PATH_KEY);
        if (sdkPath != null && this.isValidAndroidSdkPath(candidate = new File(sdkPath))) {
            return candidate;
        }
        return null;
    }

    @Nullable
    public File getAndroidNdkPath() {
        AndroidSdkHandler sdkHandler = this.myAndroidSdks.tryToChooseSdkHandler();
        LocalPackage ndk = sdkHandler.getLocalPackage("ndk-bundle", (ProgressIndicator)new StudioLoggerProgressIndicator(IdeSdks.class));
        return ndk == null ? null : ndk.getLocation();
    }

    @Nullable
    public File getJdkPath() {
        return this.doGetJdkPath(true);
    }

    @Nullable
    private File doGetJdkPath(boolean createJdkIfNeeded) {
        List<Sdk> androidSdks = this.getEligibleAndroidSdks();
        if (androidSdks.isEmpty() && createJdkIfNeeded) {
            String jdkPath;
            Sdk jdk = this.myJdks.chooseOrCreateJavaSdk();
            if (jdk != null && (jdkPath = jdk.getHomePath()) != null) {
                return new File(FileUtil.toSystemDependentName((String)jdkPath));
            }
        } else {
            for (Sdk sdk : androidSdks) {
                String jdkHomePath;
                AndroidSdkAdditionalData data = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
                assert (data != null);
                Sdk jdk = data.getJavaSdk();
                if (jdk == null || (jdkHomePath = jdk.getHomePath()) == null) continue;
                return new File(FileUtil.toSystemDependentName((String)jdkHomePath));
            }
        }
        return null;
    }

    @Nullable
    private Sdk getFirstAndroidSdk() {
        List<Sdk> allAndroidSdks = this.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        return null;
    }

    public void setJdkPath(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/IdeSdks", "setJdkPath"));
        }
        if (JdkUtil.checkForJdk((File)path)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            File canonicalPath = IdeSdks.resolvePath(path);
            Sdk chosenJdk = null;
            if (this.myIdeInfo.isAndroidStudio()) {
                List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance());
                Iterator iterator = jdks.iterator();
                while (iterator.hasNext()) {
                    Sdk jdk = (Sdk)iterator.next();
                    ProjectJdkTable.getInstance().removeJdk(jdk);
                }
            } else {
                for (Sdk jdk : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
                    if (!FileUtil.pathsEqual((String)jdk.getHomePath(), (String)canonicalPath.getPath())) continue;
                    chosenJdk = jdk;
                    break;
                }
            }
            if (chosenJdk == null) {
                if (canonicalPath.isDirectory()) {
                    Project[] openProjects;
                    chosenJdk = this.createJdk(canonicalPath);
                    if (chosenJdk == null) {
                        throw new IllegalStateException("Failed to create IDEA JDK from '" + path.getPath() + "'");
                    }
                    this.updateAndroidSdks(chosenJdk);
                    ProjectManager projectManager = (ProjectManager)ApplicationManager.getApplication().getComponent(ProjectManager.class);
                    for (Project project : openProjects = projectManager.getOpenProjects()) {
                        NewProjectUtil.applyJdkToProject((Project)project, (Sdk)chosenJdk);
                    }
                } else {
                    throw new IllegalStateException("The resolved path '" + canonicalPath.getPath() + "' was not found");
                }
            }
        }
    }

    @NotNull
    public List<Sdk> setAndroidSdkPath(@NotNull File path, @Nullable Project currentProject) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/IdeSdks", "setAndroidSdkPath"));
        }
        List<Sdk> list = this.setAndroidSdkPath(path, null, currentProject);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "setAndroidSdkPath"));
        }
        return list;
    }

    private void updateAndroidSdks(@NotNull Sdk jdk) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/android/tools/idea/sdk/IdeSdks", "updateAndroidSdks"));
        }
        for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
            AndroidSdkAdditionalData oldData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            if (oldData == null) continue;
            oldData.setJavaSdk(jdk);
            SdkModificator modificator = sdk.getSdkModificator();
            modificator.setSdkAdditionalData((SdkAdditionalData)oldData);
            modificator.commitChanges();
        }
    }

    @NotNull
    public List<Sdk> setAndroidSdkPath(@NotNull File path, @Nullable Sdk javaSdk, @Nullable Project currentProject) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/IdeSdks", "setAndroidSdkPath"));
        }
        if (this.isValidAndroidSdkPath(path)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (currentProject != null && !currentProject.isDisposed()) {
                String sdkPath = FileUtil.toCanonicalPath((String)path.getAbsolutePath());
                PropertiesComponent.getInstance((Project)currentProject).setValue(ANDROID_SDK_PATH_KEY, sdkPath);
                if (!currentProject.isDefault()) {
                    PropertiesComponent component = PropertiesComponent.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
                    component.setValue(ANDROID_SDK_PATH_KEY, sdkPath);
                }
            }
            AndroidSdkData oldSdkData = AndroidSdkData.getSdkData(path);
            this.myAndroidSdks.setSdkData(oldSdkData);
            ArrayList<Sdk> sdksToDelete = new ArrayList<Sdk>();
            File resolved = IdeSdks.resolvePath(path);
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(resolved, true);
            if (sdkData != null) {
                for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
                    if (!sdk.getName().startsWith("Android ")) continue;
                    sdksToDelete.add(sdk);
                }
            }
            for (Sdk sdk : sdksToDelete) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
            List<Sdk> sdks = this.createAndroidSdkPerAndroidTarget(resolved, javaSdk);
            IdeSdks.afterAndroidSdkPathUpdate(resolved);
            List<Sdk> list = sdks;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "setAndroidSdkPath"));
            }
            return list;
        }
        List<Sdk> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "setAndroidSdkPath"));
        }
        return list;
    }

    private static void afterAndroidSdkPathUpdate(@NotNull File androidSdkPath) {
        if (androidSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdkPath", "com/android/tools/idea/sdk/IdeSdks", "afterAndroidSdkPathUpdate"));
        }
        ProjectManager projectManager = (ProjectManager)ApplicationManager.getApplication().getComponent(ProjectManager.class);
        Project[] openProjects = projectManager.getOpenProjects();
        if (openProjects.length == 0) {
            return;
        }
        AndroidSdkEventListener[] eventListeners = (AndroidSdkEventListener[])AndroidSdkEventListener.EP_NAME.getExtensions();
        for (Project project : openProjects) {
            if (!AndroidProjectInfo.getInstance(project).requiresAndroidModel()) continue;
            for (AndroidSdkEventListener listener : eventListeners) {
                listener.afterSdkPathChange(androidSdkPath, project);
            }
        }
    }

    public boolean isValidAndroidSdkPath(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/IdeSdks", "isValidAndroidSdkPath"));
        }
        return SdkPaths.validateAndroidSdk((File)path, (boolean)false).success;
    }

    @NotNull
    public List<Sdk> createAndroidSdkPerAndroidTarget(@NotNull File androidSdkPath) {
        if (androidSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdkPath", "com/android/tools/idea/sdk/IdeSdks", "createAndroidSdkPerAndroidTarget"));
        }
        List<Sdk> sdks = this.createAndroidSdkPerAndroidTarget(androidSdkPath, null);
        AnAction sdkManagerAction = ActionManager.getInstance().getAction("WelcomeScreen.RunAndroidSdkManager");
        if (sdkManagerAction != null) {
            sdkManagerAction.update(null);
        }
        List<Sdk> list = sdks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "createAndroidSdkPerAndroidTarget"));
        }
        return list;
    }

    @NotNull
    private List<Sdk> createAndroidSdkPerAndroidTarget(@NotNull File androidSdkPath, @Nullable Sdk javaSdk) {
        Sdk ideJdk;
        if (androidSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdkPath", "com/android/tools/idea/sdk/IdeSdks", "createAndroidSdkPerAndroidTarget"));
        }
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(androidSdkPath);
        if (sdkData == null) {
            List<Sdk> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "createAndroidSdkPerAndroidTarget"));
            }
            return list;
        }
        IAndroidTarget[] targets = sdkData.getTargets(false);
        if (targets.length == 0) {
            List<Sdk> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "createAndroidSdkPerAndroidTarget"));
            }
            return list;
        }
        ArrayList<Sdk> sdks = new ArrayList<Sdk>();
        Sdk sdk = ideJdk = javaSdk != null ? javaSdk : this.getJdk();
        if (ideJdk != null) {
            for (IAndroidTarget target : targets) {
                if (!target.isPlatform() || this.doesIdeAndroidSdkExist(target)) continue;
                String name = this.myAndroidSdks.chooseNameForNewLibrary(target);
                Sdk sdk2 = this.myAndroidSdks.create(target, sdkData.getLocation(), name, ideJdk, true);
                if (sdk2 == null) continue;
                sdks.add(sdk2);
            }
        }
        ArrayList<Sdk> arrayList = sdks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "createAndroidSdkPerAndroidTarget"));
        }
        return arrayList;
    }

    private boolean doesIdeAndroidSdkExist(@NotNull IAndroidTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/IdeSdks", "doesIdeAndroidSdkExist"));
        }
        for (Sdk sdk : this.getEligibleAndroidSdks()) {
            IAndroidTarget platformTarget = IdeSdks.getTarget(sdk);
            AndroidVersion version = target.getVersion();
            AndroidVersion existingVersion = platformTarget.getVersion();
            if (!existingVersion.equals((Object)version)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static IAndroidTarget getTarget(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/sdk/IdeSdks", "getTarget"));
        }
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(sdk);
        assert (androidPlatform != null);
        IAndroidTarget iAndroidTarget = androidPlatform.getTarget();
        if (iAndroidTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "getTarget"));
        }
        return iAndroidTarget;
    }

    @NotNull
    private static File resolvePath(@NotNull File path) {
        File file;
        block4: {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/IdeSdks", "resolvePath"));
            }
            try {
                String resolvedPath = FileUtil.resolveShortWindowsName((String)path.getPath());
                file = new File(resolvedPath);
                if (file != null) break block4;
            }
            catch (IOException iOException) {
                File file2 = path;
                if (file2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "resolvePath"));
                }
                return file2;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "resolvePath"));
        }
        return file;
    }

    public boolean isUsingEmbeddedJdk() {
        File jdkPath = this.doGetJdkPath(false);
        return jdkPath != null && FileUtil.filesEqual((File)jdkPath, (File)this.myEmbeddedDistributionPaths.getEmbeddedJdkPath());
    }

    public void setUseEmbeddedJdk() {
        Preconditions.checkState((boolean)this.myIdeInfo.isAndroidStudio(), (Object)"This method is for use in Android Studio only.");
        this.setJdkPath(this.myEmbeddedDistributionPaths.getEmbeddedJdkPath());
    }

    @Nullable
    public Sdk getJdk() {
        return this.getJdk(JavaSdkVersion.JDK_1_8);
    }

    @Nullable
    private Sdk getJdk(@Nullable JavaSdkVersion preferredVersion) {
        Sdk jdk;
        List<Sdk> androidSdks = this.getEligibleAndroidSdks();
        if (!androidSdks.isEmpty()) {
            Sdk androidSdk = androidSdks.get(0);
            AndroidSdkAdditionalData data = this.myAndroidSdks.getAndroidSdkAdditionalData(androidSdk);
            assert (data != null);
            jdk = data.getJavaSdk();
            if (IdeSdks.isJdkCompatible(jdk, preferredVersion)) {
                return jdk;
            }
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        if (!jdks.isEmpty()) {
            jdk = jdks.iterator();
            while (jdk.hasNext()) {
                Sdk jdk2 = (Sdk)jdk.next();
                if (!IdeSdks.isJdkCompatible(jdk2, preferredVersion)) continue;
                return jdk2;
            }
        }
        if (this.myIdeInfo.isAndroidStudio() && (jdk = this.myJdks.createEmbeddedJdk()) != null) {
            assert (IdeSdks.isJdkCompatible(jdk, preferredVersion));
            return jdk;
        }
        List<File> jdkPaths = IdeSdks.getPotentialJdkPaths();
        for (File jdkPath : jdkPaths) {
            if (JdkUtil.checkForJdk((File)jdkPath)) {
                Sdk jdk3 = this.createJdk(jdkPath);
                return IdeSdks.isJdkCompatible(jdk3, preferredVersion) ? jdk3 : null;
            }
            if (!SystemInfo.isLinux) continue;
            for (File child : FileUtil.notNullize((File[])jdkPath.listFiles())) {
                Sdk jdk4;
                if (!child.isDirectory() || !JdkUtil.checkForJdk((File)child) || !IdeSdks.isJdkCompatible(jdk4 = this.myJdks.createJdk(child.getPath()), preferredVersion)) continue;
                return jdk4;
            }
        }
        return null;
    }

    @NotNull
    private static List<File> getPotentialJdkPaths() {
        JavaSdk javaSdk = JavaSdk.getInstance();
        ArrayList jdkPaths = Lists.newArrayList((Iterable)javaSdk.suggestHomePaths());
        jdkPaths.add(SystemProperties.getJavaHome());
        ArrayList virtualFiles = Lists.newArrayListWithCapacity((int)jdkPaths.size());
        for (String jdkPath : jdkPaths) {
            File javaHome;
            if (jdkPath == null || !(javaHome = new File(jdkPath)).isDirectory()) continue;
            virtualFiles.add(javaHome);
        }
        ArrayList arrayList = virtualFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "getPotentialJdkPaths"));
        }
        return arrayList;
    }

    private static boolean isJdkCompatible(@Nullable Sdk jdk, @Nullable JavaSdkVersion preferredVersion) {
        if (jdk == null) {
            return false;
        }
        if (preferredVersion == null) {
            return true;
        }
        return JavaSdk.getInstance().isOfVersionOrHigher(jdk, preferredVersion);
    }

    @NotNull
    public List<Sdk> getEligibleAndroidSdks() {
        ArrayList<Sdk> sdks = new ArrayList<Sdk>();
        for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
            if (!sdk.getName().startsWith("Android ") || AndroidPlatform.getInstance(sdk) == null) continue;
            sdks.add(sdk);
        }
        ArrayList<Sdk> arrayList = sdks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/IdeSdks", "getEligibleAndroidSdks"));
        }
        return arrayList;
    }

    @Nullable
    private Sdk createJdk(@NotNull File homeDirectory) {
        if (homeDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homeDirectory", "com/android/tools/idea/sdk/IdeSdks", "createJdk"));
        }
        return this.myJdks.createJdk(homeDirectory.getPath());
    }

    public boolean isJdk7Supported(@Nullable AndroidSdkData sdkData) {
        if (sdkData != null) {
            Revision revision;
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(Jdks.class);
            LocalPackage info = sdkData.getSdkHandler().getLocalPackage("platform-tools", (ProgressIndicator)progress);
            if (info != null && (revision = info.getVersion()).getMajor() >= 19) {
                JavaSdkVersion version;
                JavaSdk jdk = JavaSdk.getInstance();
                Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk);
                if (sdk != null && (version = jdk.getVersion(sdk)) != null && version.isAtLeast(JavaSdkVersion.JDK_1_7)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static interface AndroidSdkEventListener {
        public static final ExtensionPointName<AndroidSdkEventListener> EP_NAME = ExtensionPointName.create((String)"com.android.ide.sdkEventListener");

        public void afterSdkPathChange(@NotNull File var1, @NotNull Project var2);
    }
}

