/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.License;
import com.android.repository.api.RemotePackage;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.swing.SelectedProperty;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LicenseAgreementStep
extends ModelWizardStep<LicenseAgreementModel> {
    private JTextPane myLicenseTextField;
    private Tree myChangeTree;
    private JBRadioButton myDeclineRadioButton;
    private JBRadioButton myAcceptRadioButton;
    private JPanel myRootPanel;
    private Splitter splitter;
    private JPanel optionsPanel;
    private JBScrollPane myTreeScroll;
    private JBScrollPane myLicensePane;
    private DefaultTreeModel myTreeModel;
    @Nullable
    private String myCurrentLicense;
    private Map<String, Boolean> myAcceptances;
    private Set<String> myVisibleLicenses;
    private List<RemotePackage> myInstallRequests;
    private BoolProperty myAllLicensesAreAccepted;

    protected LicenseAgreementStep(@NotNull LicenseAgreementModel model, @NotNull List<RemotePackage> installRequests) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep", "<init>"));
        }
        if (installRequests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installRequests", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep", "<init>"));
        }
        super(model, "License Agreement");
        this.$$$setupUI$$$();
        this.myTreeModel = new DefaultTreeModel(null);
        this.myAcceptances = Maps.newHashMap();
        this.myVisibleLicenses = Sets.newHashSet();
        this.myAllLicensesAreAccepted = new BoolValueProperty();
        this.myInstallRequests = installRequests;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep", "onWizardStarting"));
        }
        this.createUI();
        this.initUI();
    }

    private void createUI() {
        this.splitter.setHonorComponentsMinimumSize(true);
        ButtonGroup optionsGroup = new ButtonGroup();
        optionsGroup.add((AbstractButton)this.myDeclineRadioButton);
        optionsGroup.add((AbstractButton)this.myAcceptRadioButton);
        this.myRootPanel.add((Component)this.splitter, "Center");
        this.myRootPanel.add((Component)this.optionsPanel, "South");
        this.myLicenseTextField.setFont(UIUtil.getLabelFont());
    }

    private void initUI() {
        this.myChangeTree.setModel((TreeModel)this.myTreeModel);
        this.myChangeTree.setShowsRootHandles(false);
        this.myLicenseTextField.setEditable(false);
        final SelectedProperty accepted = new SelectedProperty((AbstractButton)this.myAcceptRadioButton);
        accepted.addListener(new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep$1", "onInvalidated"));
                }
                LicenseAgreementStep.this.myAcceptances.put(LicenseAgreementStep.this.myCurrentLicense, accepted.get());
                LicenseAgreementStep.this.checkAllLicensesAreAccepted();
                LicenseAgreementStep.this.myChangeTree.repaint();
            }
        });
        this.myChangeTree.addTreeSelectionListener(this.createTreeSelectionListener());
        this.myChangeTree.setCellRenderer((TreeCellRenderer)this.createCellRenderer());
        this.setChanges(this.createChangesList());
    }

    private TreeSelectionListener createTreeSelectionListener() {
        return new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode selected = (DefaultMutableTreeNode)LicenseAgreementStep.this.myChangeTree.getLastSelectedPathComponent();
                if (selected != null && selected.isRoot()) {
                    return;
                }
                if (selected != null && !selected.isLeaf()) {
                    License license = (License)selected.getUserObject();
                    LicenseAgreementStep.this.myLicenseTextField.setText(license.getValue());
                    LicenseAgreementStep.this.myCurrentLicense = license.getId();
                } else if (selected != null && !selected.isRoot()) {
                    Change change = (Change)selected.getUserObject();
                    LicenseAgreementStep.this.myLicenseTextField.setText(change.license.getValue());
                    LicenseAgreementStep.this.myCurrentLicense = change.license.getId();
                }
                if (((Boolean)LicenseAgreementStep.this.myAcceptances.get(LicenseAgreementStep.this.myCurrentLicense)).booleanValue()) {
                    LicenseAgreementStep.this.myAcceptRadioButton.setSelected(true);
                } else {
                    LicenseAgreementStep.this.myDeclineRadioButton.setSelected(true);
                }
                LicenseAgreementStep.this.myLicenseTextField.setCaretPosition(0);
            }
        };
    }

    private ColoredTreeCellRenderer createCellRenderer() {
        return new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep$3", "customizeCellRenderer"));
                }
                if (row == 0) {
                    this.append("Licenses", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (!leaf) {
                    License license = (License)node.getUserObject();
                    this.appendLicenseText(license, license.getId());
                } else {
                    Change change = (Change)node.getUserObject();
                    if (change == null) {
                        return;
                    }
                    this.appendLicenseText(change.license, change.toString());
                    this.setIcon(AllIcons.Actions.Download);
                }
            }

            private void appendLicenseText(@Nullable License license, String text) {
                boolean notAccepted;
                boolean bl = notAccepted = license != null && (Boolean)LicenseAgreementStep.this.myAcceptances.get(license.getId()) == false;
                if (notAccepted) {
                    this.append("*", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.append(text, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else {
                    this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        };
    }

    private void expandTree() {
        for (int i = 0; i < this.myChangeTree.getRowCount(); ++i) {
            this.myChangeTree.expandRow(i);
        }
    }

    private void setChanges(List<Change> changes) {
        HashMap licenseNodeMap = Maps.newHashMap();
        this.myVisibleLicenses.clear();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultMutableTreeNode firstChild = null;
        for (Change change : changes) {
            String licenseRef = change.license.getId();
            this.myVisibleLicenses.add(licenseRef);
            if (!licenseNodeMap.containsKey(licenseRef)) {
                DefaultMutableTreeNode n = new DefaultMutableTreeNode(change.license);
                if (firstChild == null) {
                    firstChild = n;
                }
                licenseNodeMap.put(licenseRef, n);
                this.myAcceptances.put(licenseRef, Boolean.FALSE);
                root.add(n);
            }
            ((DefaultMutableTreeNode)licenseNodeMap.get(licenseRef)).add(new DefaultMutableTreeNode(change));
        }
        this.myTreeModel = new DefaultTreeModel(root);
        this.myChangeTree.setModel((TreeModel)this.myTreeModel);
        this.expandTree();
        if (firstChild != null) {
            this.myChangeTree.setSelectionPath(new TreePath(firstChild.getPath()));
        }
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep", "getComponent"));
        }
        return jPanel;
    }

    @Override
    protected boolean shouldShow() {
        return this.myVisibleLicenses.size() > 0 && !((LicenseAgreementModel)this.getModel()).getLicenses().isEmpty();
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myChangeTree;
    }

    private void checkAllLicensesAreAccepted() {
        this.myAllLicensesAreAccepted.set(true);
        for (String licenseRef : this.myVisibleLicenses) {
            if (this.myAcceptances.get(licenseRef).booleanValue()) continue;
            this.myAllLicensesAreAccepted.set(false);
            break;
        }
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        BoolProperty boolProperty = this.myAllLicensesAreAccepted;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep", "canGoForward"));
        }
        return boolProperty;
    }

    private List<Change> createChangesList() {
        ArrayList toReturn = Lists.newArrayList();
        if (this.myInstallRequests != null) {
            for (RemotePackage p : this.myInstallRequests) {
                License license = p.getLicense();
                if (license == null) continue;
                ((LicenseAgreementModel)this.getModel()).getLicenses().add(license);
                if (license.checkAccepted(((LicenseAgreementModel)this.getModel()).sdkRoot().getValue(), FileOpUtils.create())) continue;
                toReturn.add(new Change(p, license));
            }
        }
        return toReturn;
    }

    private void createUIComponents() {
        this.optionsPanel = new JPanel(new FlowLayout(4));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JTextPane jTextPane;
        JBScrollPane jBScrollPane;
        Tree tree;
        JBScrollPane jBScrollPane2;
        Splitter splitter;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setPreferredSize(new Dimension(230, 160));
        jPanel.setMinimumSize(new Dimension(230, 160));
        jPanel.setMaximumSize(new Dimension(1250, 937));
        this.splitter = splitter = new Splitter();
        splitter.setLayout(new FlowLayout(1, 5, 5));
        splitter.setPreferredSize(new Dimension(230, 160));
        splitter.setMaximumSize(new Dimension(1250, 937));
        splitter.setProportion(0.3f);
        splitter.setShowDividerControls(false);
        splitter.setShowDividerIcon(false);
        jPanel.add((Component)splitter, "Center");
        this.myTreeScroll = jBScrollPane2 = new JBScrollPane();
        Component component = splitter.add((Component)jBScrollPane2);
        this.myChangeTree = tree = new Tree();
        jBScrollPane2.setViewportView((Component)tree);
        this.myLicensePane = jBScrollPane = new JBScrollPane();
        Component component2 = splitter.add((Component)jBScrollPane);
        this.myLicenseTextField = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setPreferredSize(new Dimension(230, 160));
        jTextPane.setAutoscrolls(false);
        jTextPane.setMaximumSize(new Dimension(1250, 937));
        jTextPane.putClientProperty("charset", "");
        jTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.FALSE);
        jBScrollPane.setViewportView(jTextPane);
        JPanel jPanel2 = this.optionsPanel;
        jPanel2.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add((Component)jPanel2, "South");
        this.myDeclineRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("Decline");
        Component component3 = jPanel2.add((Component)jBRadioButton2);
        this.myAcceptRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Accept");
        Component component4 = jPanel2.add((Component)jBRadioButton);
        splitter.setSecondComponent((JComponent)jBScrollPane);
        splitter.setFirstComponent((JComponent)jBScrollPane2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static final class Change {
        public RemotePackage myPackage;
        public License license;

        public Change(@NotNull RemotePackage p, @NotNull License license) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep$Change", "<init>"));
            }
            if (license == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "license", "com/android/tools/idea/sdk/wizard/LicenseAgreementStep$Change", "<init>"));
            }
            this.myPackage = p;
            this.license = license;
        }

        public String toString() {
            return this.myPackage.getDisplayName();
        }
    }
}

