/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.structure.services.BuildSystemOperationsLookup;
import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServiceCreator;
import com.android.tools.idea.structure.services.DeveloperServiceCreators;
import com.android.tools.idea.structure.services.ServiceCategory;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public final class DeveloperServices {
    private static final Logger LOG = Logger.getInstance(DeveloperService.class);
    private static Multimap<Module, DeveloperService> ourServices = ArrayListMultimap.create();

    public static Iterable<DeveloperService> getAll(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/structure/services/DeveloperServices", "getAll"));
        }
        DeveloperServices.initializeFor(module);
        return ourServices.get((Object)module);
    }

    @NotNull
    public static Iterable<DeveloperService> getFor(@NotNull Module module, final ServiceCategory category) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/structure/services/DeveloperServices", "getFor"));
        }
        Iterable iterable = Iterables.filter(DeveloperServices.getAll(module), (Predicate)new Predicate<DeveloperService>(){

            public boolean apply(DeveloperService service) {
                return service.getCategory() == category;
            }
        });
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperServices", "getFor"));
        }
        return iterable;
    }

    private static void initializeFor(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/structure/services/DeveloperServices", "initializeFor"));
        }
        if (ourServices.containsKey((Object)module)) {
            return;
        }
        for (DeveloperServiceCreators creators : (DeveloperServiceCreators[])DeveloperServiceCreators.EP_NAME.getExtensions()) {
            try {
                for (DeveloperServiceCreator developerServiceCreator : creators.getCreators()) {
                    DeveloperService service = developerServiceCreator.createService(module);
                    if (service == null) continue;
                    ourServices.put((Object)module, (Object)service);
                }
            }
            catch (Exception e) {
                LOG.warn("Caught exception while initializing services", (Throwable)e);
            }
        }
        BuildSystemOperationsLookup.getBuildSystemOperations(module.getProject()).initializeServices(module, new Runnable(){

            @Override
            public void run() {
                for (DeveloperService service : ourServices.get((Object)module)) {
                    service.updateInstalledState();
                }
            }
        });
        MessageBusConnection connection = module.getMessageBus().connect((Disposable)module);
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module moduleRemoved) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/structure/services/DeveloperServices$3", "moduleRemoved"));
                }
                if (moduleRemoved == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRemoved", "com/android/tools/idea/structure/services/DeveloperServices$3", "moduleRemoved"));
                }
                if (module == moduleRemoved) {
                    ourServices.removeAll((Object)module);
                }
            }
        });
    }
}

