/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.junit;

import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationProducer;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationType;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurations;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Iterator;

public class TestMethodAndroidConfigurationProducer
extends JUnitConfigurationProducer
implements AndroidJUnitConfigurationProducer {
    protected TestMethodAndroidConfigurationProducer() {
        super((ConfigurationType)AndroidJUnitConfigurationType.getInstance());
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return super.isPreferredConfiguration(self, other) && AndroidJUnitConfigurations.shouldUseAndroidJUnitConfigurations(self, other);
    }

    public boolean shouldReplace(ConfigurationFromContext self, ConfigurationFromContext other) {
        return super.isPreferredConfiguration(self, other) && AndroidJUnitConfigurations.shouldUseAndroidJUnitConfigurations(self, other);
    }

    protected boolean setupConfigurationFromContext(JUnitConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        MethodLocation methodLocation = TestMethodAndroidConfigurationProducer.getTestMethod(contextLocation);
        if (methodLocation == null) {
            return false;
        }
        if (contextLocation instanceof PsiMemberParameterizedLocation) {
            PsiClass containingClass;
            String paramSetName = ((PsiMemberParameterizedLocation)contextLocation).getParamSetName();
            if (paramSetName != null) {
                configuration.setProgramParameters(paramSetName);
            }
            if ((containingClass = ((PsiMemberParameterizedLocation)contextLocation).getContainingClass()) != null) {
                methodLocation = MethodLocation.elementInClass((PsiMethod)((PsiMethod)methodLocation.getPsiElement()), (PsiClass)containingClass);
            }
        }
        sourceElement.set((Object)methodLocation.getPsiElement());
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        configuration.beMethodConfiguration(methodLocation);
        configuration.restoreOriginalModule(originalModule);
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, contextLocation);
        configuration.setForkMode("none");
        return true;
    }

    private static Location<PsiMethod> getTestMethod(Location<?> location) {
        Iterator iterator = location.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            Location methodLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestMethod((Location)methodLocation, (boolean)false)) continue;
            return methodLocation;
        }
        return null;
    }

    public boolean isConfigurationFromContext(JUnitConfiguration unitConfiguration, ConfigurationContext context) {
        return AndroidJUnitConfigurations.isFromContext(unitConfiguration, context, this.getConfigurationFactory());
    }
}

