/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.uibuilder.editor.NlEditor;
import com.android.tools.idea.uibuilder.editor.NlPreviewManager;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.util.NlTreeDumper;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import icons.AndroidIcons;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateLayoutTestSkeletonAction
extends AnAction {
    private static final Pattern XML_PROLOG = Pattern.compile("^<\\?xml version.*$");

    public GenerateLayoutTestSkeletonAction() {
        super("Generate LayoutTest Skeleton");
    }

    public void update(AnActionEvent event) {
        event.getPresentation().setEnabled(GenerateLayoutTestSkeletonAction.getModel(event.getProject()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "actionPerformed"));
        }
        NlModel model = GenerateLayoutTestSkeletonAction.getModel(event.getProject());
        if (model == null) {
            return;
        }
        int option = Messages.showDialog((Project)model.getProject(), (String)"Generate LayoutTest skeleton with the current layout components.", (String)"Generate LayoutTest Skeleton", (String[])new String[]{"Copy to Clipboard", "Cancel"}, (int)0, (Icon)AndroidIcons.AndroidTestRoot);
        if (option == 0) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(GenerateLayoutTestSkeletonAction.generateModelFixture(model)));
        }
    }

    @Nullable
    private static NlModel getModel(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        DesignSurface surface = GenerateLayoutTestSkeletonAction.getSurface(project);
        if (surface == null) {
            return null;
        }
        ScreenView screenView = surface.getCurrentScreenView();
        if (screenView == null) {
            return null;
        }
        return screenView.getModel();
    }

    @Nullable
    private static DesignSurface getSurface(@NotNull Project project) {
        FileEditor[] editors;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "getSurface"));
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : editors = fileEditorManager.getSelectedEditors()) {
            if (!(fileEditor instanceof NlEditor)) continue;
            return ((NlEditor)fileEditor).getComponent().getSurface();
        }
        Editor editor = fileEditorManager.getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        NlPreviewManager previewManager = NlPreviewManager.getInstance(project);
        if (previewManager.isWindowVisible()) {
            return previewManager.getPreviewForm().getSurface();
        }
        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file == null) {
            return null;
        }
        for (FileEditor fileEditor : fileEditorManager.getEditors(file.getVirtualFile())) {
            if (!(fileEditor instanceof NlEditor)) continue;
            return ((NlEditor)fileEditor).getComponent().getSurface();
        }
        return null;
    }

    @NotNull
    private static String generateModelFixture(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "generateModelFixture"));
        }
        List<NlComponent> components = model.getComponents();
        StringBuilder builder = new StringBuilder();
        builder.append("import com.android.tools.idea.uibuilder.LayoutTestCase;\n").append("import com.android.tools.idea.uibuilder.fixtures.ModelBuilder;\n").append("import com.android.tools.idea.uibuilder.model.NlModel;\n").append("import com.android.tools.idea.uibuilder.util.NlTreeDumper;\n").append("import org.jetbrains.annotations.NotNull;\n").append("\n").append("import static com.android.SdkConstants.*;\n").append("\n").append("public class NewTest extends LayoutTestCase {\n").append("\n").append("  // TODO: Rename this test method\n").append("  public void testRenameThis() {\n").append("    NlModel model = createModel();\n").append("  }\n").append("\n").append("  @NotNull\n").append("  private NlModel createModel() {\n").append("    ModelBuilder builder = model(\"").append(model.getFile().getName()).append("\",\n");
        for (NlComponent component : components) {
            GenerateLayoutTestSkeletonAction.appendComponent(component, "\"    ModelBuilder builder = model(".length(), builder);
        }
        builder.append(");\n");
        builder.append("    NlModel model = builder.build();\n").append("    format(model.getFile());\n").append("    assertEquals(").append(components.size()).append(", model.getComponents().size());\n");
        GenerateLayoutTestSkeletonAction.appendTreeComparison(components, builder);
        GenerateLayoutTestSkeletonAction.appendXmlComparison(model, builder);
        builder.append("\n").append("    return model;\n").append("  }\n").append("}\n");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "generateModelFixture"));
        }
        return string;
    }

    private static void appendComponent(@NotNull NlComponent component, int indent, @NotNull StringBuilder builder) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendComponent"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendComponent"));
        }
        builder.append(StringUtil.repeat((String)" ", (int)indent)).append("component(").append(GenerateLayoutTestSkeletonAction.getTagSymbol(component.getTagName())).append(")\n").append(StringUtil.repeat((String)" ", (int)(indent + 2))).append(GenerateLayoutTestSkeletonAction.makeBounds(component)).append("\n");
        for (AttributeSnapshot attribute : component.getAttributes()) {
            GenerateLayoutTestSkeletonAction.appendAttribute(attribute, indent + 4, builder);
        }
        if (component.getChildCount() > 0) {
            builder.append(StringUtil.repeat((String)" ", (int)(indent + 2))).append(".children(\n");
            for (NlComponent child : component.getChildren()) {
                GenerateLayoutTestSkeletonAction.appendComponent(child, indent + 4, builder);
                builder.replace(builder.length() - 1, builder.length(), ",\n\n");
            }
            builder.replace(builder.length() - 3, builder.length(), ")\n");
        }
    }

    private static void appendAttribute(@NotNull AttributeSnapshot attribute, int indent, @NotNull StringBuilder builder) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendAttribute"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendAttribute"));
        }
        if (GenerateLayoutTestSkeletonAction.implicitAttribute(attribute)) {
            return;
        }
        assert (attribute.value != null);
        if ("android".equals(attribute.prefix)) {
            switch (attribute.name) {
                case "id": {
                    GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".id", attribute.value, builder);
                    return;
                }
                case "text": {
                    GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".text", attribute.value, builder);
                    return;
                }
                case "layout_height": {
                    GenerateLayoutTestSkeletonAction.appendHeightOrWidth(indent, attribute.value, "height", builder);
                    return;
                }
                case "layout_width": {
                    GenerateLayoutTestSkeletonAction.appendHeightOrWidth(indent, attribute.value, "width", builder);
                    return;
                }
            }
        }
        GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".withAttribute", attribute.prefix, attribute.name, attribute.value, builder);
    }

    private static void appendHeightOrWidth(int indent, @NotNull String value, @NotNull String orientation, @NotNull StringBuilder builder) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendHeightOrWidth"));
        }
        if (orientation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orientation", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendHeightOrWidth"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendHeightOrWidth"));
        }
        switch (value) {
            case "wrap_content": {
                GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".wrapContent" + StringUtil.capitalize((String)orientation), builder);
                break;
            }
            case "match_parent": {
                GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".matchParent" + StringUtil.capitalize((String)orientation), builder);
                break;
            }
            default: {
                GenerateLayoutTestSkeletonAction.appendAttribute(indent, "." + orientation, value, builder);
            }
        }
    }

    private static void appendAttribute(int indent, @NotNull String with, @NotNull StringBuilder builder) {
        if (with == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "with", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendAttribute"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendAttribute"));
        }
        builder.append(StringUtil.repeat((String)" ", (int)indent)).append(with).append("()\n");
    }

    private static void appendAttribute(int indent, @NotNull String with, @Nullable String value, @NotNull StringBuilder builder) {
        if (with == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "with", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendAttribute"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendAttribute"));
        }
        GenerateLayoutTestSkeletonAction.appendAttribute(indent, with, null, null, value, builder);
    }

    private static void appendAttribute(int indent, @NotNull String with, @Nullable String prefix, @Nullable String name, @Nullable String value, @NotNull StringBuilder builder) {
        if (with == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "with", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendAttribute"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendAttribute"));
        }
        if (value == null) {
            return;
        }
        builder.append(StringUtil.repeat((String)" ", (int)indent)).append(with).append("(\"");
        if (prefix != null) {
            builder.append(prefix).append(":");
        }
        if (name != null) {
            builder.append(name).append("\", \"");
        }
        builder.append(value).append("\")\n");
    }

    private static boolean implicitAttribute(@NotNull AttributeSnapshot attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "implicitAttribute"));
        }
        if ("xmlns".equals(attribute.prefix)) {
            return true;
        }
        return attribute.value == null;
    }

    @NotNull
    private static String makeBounds(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "makeBounds"));
        }
        Rectangle bounds = GenerateLayoutTestSkeletonAction.getBounds(component);
        String string = String.format(".withBounds(%d, %d, %d, %d)", bounds.x, bounds.y, bounds.width, bounds.height);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "makeBounds"));
        }
        return string;
    }

    @NotNull
    private static Rectangle getBounds(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "getBounds"));
        }
        NlComponent parent = component.getParent();
        Rectangle parentBounds = parent != null ? GenerateLayoutTestSkeletonAction.getBounds(parent) : new Rectangle(0, 0, 1000, 1000);
        ViewInfo viewInfo = component.viewInfo;
        if (viewInfo == null) {
            Rectangle rectangle = new Rectangle(parentBounds.x, parentBounds.y, 100, 100);
            if (rectangle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "getBounds"));
            }
            return rectangle;
        }
        Rectangle rectangle = new Rectangle(viewInfo.getLeft() + parentBounds.x, viewInfo.getTop() + parentBounds.y, viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "getBounds"));
        }
        return rectangle;
    }

    @NotNull
    private static String getTagSymbol(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "getTagSymbol"));
        }
        tagName = tagName.substring(1 + tagName.lastIndexOf(46));
        String string = TemplateUtils.camelCaseToUnderlines(tagName).toUpperCase(Locale.ROOT);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "getTagSymbol"));
        }
        return string;
    }

    private static void appendTreeComparison(@NotNull List<NlComponent> components, @NotNull StringBuilder builder) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendTreeComparison"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendTreeComparison"));
        }
        GenerateLayoutTestSkeletonAction.appendMultilineAssert(NlTreeDumper.dumpTree(components), "NlTreeDumper.dumpTree(model.getComponents())", builder, (List<Pattern>)ImmutableList.of(), false);
    }

    private static void appendXmlComparison(@NotNull NlModel model, @NotNull StringBuilder builder) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendXmlComparison"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendXmlComparison"));
        }
        GenerateLayoutTestSkeletonAction.appendMultilineAssert(model.getFile().getText(), "model.getFile().getText()", builder, (List<Pattern>)ImmutableList.of((Object)XML_PROLOG), true);
    }

    private static void appendMultilineAssert(@NotNull String expectedMultilineResult, @NotNull String subject, @NotNull StringBuilder builder, @NotNull List<Pattern> lineFilters, boolean addNewlineToLastLine) {
        if (expectedMultilineResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedMultilineResult", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendMultilineAssert"));
        }
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendMultilineAssert"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendMultilineAssert"));
        }
        if (lineFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineFilters", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "appendMultilineAssert"));
        }
        String assertEquals = "    assertEquals(";
        builder.append(assertEquals);
        String lastLine = "";
        int indent = 0;
        for (String line : Splitter.on((String)"\n").split((CharSequence)expectedMultilineResult)) {
            if (GenerateLayoutTestSkeletonAction.matches(line, lineFilters)) continue;
            builder.append(StringUtil.repeat((String)" ", (int)indent));
            builder.append("\"").append(line.replace("\"", "\\\"")).append("\\n\" +\n");
            indent = assertEquals.length();
            lastLine = line;
        }
        if (indent > 0) {
            builder.setLength(builder.length() - 6);
            if (lastLine.isEmpty()) {
                builder.setLength(builder.length() - 1 - indent - 6);
            }
            if (addNewlineToLastLine) {
                builder.append("\\n");
            }
            builder.append("\",\n");
        } else {
            builder.append("\"\",\n");
        }
        builder.append(StringUtil.repeat((String)" ", (int)assertEquals.length()));
        builder.append(subject).append(");\n");
    }

    private static boolean matches(@NotNull String line, @NotNull List<Pattern> lineFilters) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "matches"));
        }
        if (lineFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineFilters", "com/android/tools/idea/uibuilder/actions/GenerateLayoutTestSkeletonAction", "matches"));
        }
        for (Pattern pattern : lineFilters) {
            if (!pattern.matcher(line).matches()) continue;
            return true;
        }
        return false;
    }
}

