/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.tools.idea.uibuilder.api.PaletteComponentHandler;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyComponentHandler
extends PaletteComponentHandler {
    @NotNull
    public List<String> getInspectorProperties() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/api/PropertyComponentHandler", "getInspectorProperties"));
        }
        return list;
    }

    @Nullable
    public String getPreferredProperty() {
        return "id";
    }

    @NotNull
    public List<String> getBaseStyles(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/android/tools/idea/uibuilder/api/PropertyComponentHandler", "getBaseStyles"));
        }
        String simpleTagName = PropertyComponentHandler.getSimpleTagName(tagName);
        if (tagName.startsWith("android.support.design.")) {
            ImmutableList immutableList = ImmutableList.of((Object)("Widget.Design." + simpleTagName));
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/api/PropertyComponentHandler", "getBaseStyles"));
            }
            return immutableList;
        }
        if (tagName.equals(simpleTagName)) {
            ImmutableList immutableList = ImmutableList.of((Object)("Widget." + simpleTagName), (Object)("Widget.Material." + simpleTagName));
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/api/PropertyComponentHandler", "getBaseStyles"));
            }
            return immutableList;
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/api/PropertyComponentHandler", "getBaseStyles"));
        }
        return immutableList;
    }
}

