/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.uibuilder.analytics.NlUsageTrackerManager;
import com.android.tools.idea.uibuilder.editor.NlEditorPanel;
import com.android.tools.idea.uibuilder.editor.NlPreviewForm;
import com.android.tools.idea.uibuilder.model.NlLayoutType;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NlAbstractWindowManager
extends LightToolWindowManager {
    private ToolWindowType myPreviousWindowType;
    private ToolWindowAnchor myPreviousWindowAnchor;
    private DesignSurface myDesignSurface;

    public NlAbstractWindowManager(@NotNull Project project, @NotNull FileEditorManager fileEditorManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "<init>"));
        }
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "<init>"));
        }
        super(project, fileEditorManager);
    }

    protected void initToolWindow(final @NotNull String id, @NotNull Icon icon) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "initToolWindow"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "initToolWindow"));
        }
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(id, false, this.getAnchor(), (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(icon);
        this.myToolWindow.setAvailable(false, null);
        this.myToolWindow.setAutoHide(false);
        this.myPreviousWindowType = this.myToolWindow.getType();
        this.myPreviousWindowAnchor = this.getEditorMode();
        ((ToolWindowManagerEx)ToolWindowManager.getInstance((Project)this.myProject)).addToolWindowManagerListener((ToolWindowManagerListener)new ToolWindowManagerAdapter(){

            public void stateChanged() {
                if (NlAbstractWindowManager.this.myProject.isDisposed()) {
                    return;
                }
                ToolWindow window = ToolWindowManager.getInstance((Project)NlAbstractWindowManager.this.myProject).getToolWindow(id);
                ToolWindowType newWindowType = window.getType();
                ToolWindowAnchor newWindowAnchor = NlAbstractWindowManager.this.getEditorMode();
                if (newWindowType != NlAbstractWindowManager.this.myPreviousWindowType || newWindowAnchor != NlAbstractWindowManager.this.myPreviousWindowAnchor) {
                    NlUsageTrackerManager.getInstance(NlAbstractWindowManager.this.myDesignSurface).logAction(LayoutEditorEvent.LayoutEditorEventType.UNKNOWN_EVENT_TYPE);
                    NlAbstractWindowManager.this.myPreviousWindowType = newWindowType;
                    NlAbstractWindowManager.this.myPreviousWindowAnchor = newWindowAnchor;
                }
            }
        }, (Disposable)this.myProject);
        this.initGearActions();
    }

    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        this.myDesignSurface = NlAbstractWindowManager.getDesignSurface(designer);
    }

    @Nullable
    protected DesignerEditorPanelFacade getDesigner(@Nullable FileEditor editor) {
        return null;
    }

    protected ToggleEditorModeAction createToggleAction(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "createToggleAction"));
        }
        return new ToggleEditorModeAction(this, this.myProject, anchor){

            protected LightToolWindowManager getOppositeManager() {
                return null;
            }
        };
    }

    @Nullable
    protected static DesignSurface getDesignSurface(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "getDesignSurface"));
        }
        if (designer instanceof NlEditorPanel) {
            NlEditorPanel editor = (NlEditorPanel)designer;
            return editor.getSurface();
        }
        if (designer instanceof NlPreviewForm) {
            NlPreviewForm form = (NlPreviewForm)designer;
            return form.getFile() != null ? form.getSurface() : null;
        }
        throw new RuntimeException(designer.getClass().getName());
    }

    @NotNull
    protected static NlLayoutType getLayoutType(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "getLayoutType"));
        }
        DesignSurface designSurface = NlAbstractWindowManager.getDesignSurface(designer);
        NlLayoutType nlLayoutType = designSurface != null ? designSurface.getLayoutType() : NlLayoutType.UNKNOWN;
        if (nlLayoutType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "getLayoutType"));
        }
        return nlLayoutType;
    }

    protected void createWindowContent(@NotNull JComponent contentPane, @NotNull JComponent focusedComponent, @Nullable AnAction[] actions) {
        if (contentPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentPane", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "createWindowContent"));
        }
        if (focusedComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusedComponent", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "createWindowContent"));
        }
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent(contentPane, null, false);
        content.setCloseable(false);
        content.setPreferredFocusableComponent(focusedComponent);
        if (actions != null) {
            ToolWindowEx toolWindow = (ToolWindowEx)this.myToolWindow;
            toolWindow.setTitleActions(actions);
        }
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
    }

    @Nullable
    public abstract Object getToolWindowContent(@NotNull DesignerEditorPanelFacade var1);

    public void activateToolWindow(@NotNull DesignerEditorPanelFacade designer, @NotNull Runnable runnable) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "activateToolWindow"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "activateToolWindow"));
        }
        LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty((Object)this.getComponentName());
        if (toolWindow != null) {
            NlAbstractWindowManager.restore(toolWindow);
            runnable.run();
        } else {
            this.myToolWindow.show(runnable);
        }
    }

    private static void restore(@NotNull LightToolWindow toolWindow) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager", "restore"));
        }
        try {
            Method updateContent = LightToolWindow.class.getDeclaredMethod("updateContent", Boolean.TYPE, Boolean.TYPE);
            if (updateContent != null) {
                updateContent.setAccessible(true);
                updateContent.invoke((Object)toolWindow, Boolean.TRUE, Boolean.TRUE);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }
}

